/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.globallocker;

import java.io.IOException;
import java.util.UUID;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.globallocker.LockerType;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.LockFailedException;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMysqlGlobalLocker
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testSimpleLocking() throws IOException, LockFailedException {
        String lockName = UUID.randomUUID().toString();
        GlobalLock lock = this.locker.lockWithNumberOfTries(LockerType.ACCNT_INV_PAY.toString(), lockName, 3);
        this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle conn, TransactionStatus status) throws Exception {
                conn.execute("insert into dummy2 (dummy_id) values ('" + UUID.randomUUID().toString() + "')", new Object[0]);
                return null;
            }
        });
        Assert.assertEquals((boolean)this.locker.isFree(LockerType.ACCNT_INV_PAY.toString(), lockName), (boolean)false);
        boolean gotException = false;
        try {
            this.locker.lockWithNumberOfTries(LockerType.ACCNT_INV_PAY.toString(), lockName, 1);
        }
        catch (LockFailedException e) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        lock.release();
        Assert.assertEquals((boolean)this.locker.isFree(LockerType.ACCNT_INV_PAY.toString(), lockName), (boolean)true);
    }
}

