/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.glue;

import com.google.inject.Module;
import org.killbill.billing.GuicyKillbillTestNoDBModule;
import org.killbill.billing.mock.glue.MockGlobalLockerModule;
import org.killbill.billing.mock.glue.MockNonEntityDaoModule;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.util.api.AuditUserApi;
import org.killbill.billing.util.audit.api.DefaultAuditUserApi;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.audit.dao.MockAuditDao;
import org.killbill.billing.util.glue.KillBillShiroAopModule;
import org.killbill.billing.util.glue.KillBillShiroModule;
import org.killbill.billing.util.glue.SecurityModule;
import org.killbill.billing.util.glue.TestUtilModule;

public class TestUtilModuleNoDB
extends TestUtilModule {
    public TestUtilModuleNoDB(KillbillConfigSource configSource) {
        super(configSource);
    }

    private void installAuditMock() {
        this.bind(AuditDao.class).toInstance((Object)new MockAuditDao());
        this.bind(AuditUserApi.class).to(DefaultAuditUserApi.class).asEagerSingleton();
    }

    protected void configure() {
        super.configure();
        this.install((Module)new GuicyKillbillTestNoDBModule(this.configSource));
        this.install((Module)new MockNonEntityDaoModule(this.configSource));
        this.install((Module)new MockGlobalLockerModule(this.configSource));
        this.installAuditMock();
        this.install((Module)new ShiroModuleNoDB(this.configSource));
        this.install((Module)new KillBillShiroAopModule());
        this.install((Module)new SecurityModule(this.configSource));
    }

    public static class ShiroModuleNoDB
    extends KillBillShiroModule {
        public ShiroModuleNoDB(KillbillConfigSource configSource) {
            super(configSource);
        }

        protected void configureJDBCRealm() {
        }

        protected void configureLDAPRealm() {
        }
    }
}

