/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.migration;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.SqlStatement;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapturingMetaDataTable
extends MetaDataTableImpl {
    private final List<SqlStatement> sqlStatements;
    private final DbSupport dbSupport;
    private final Table table;

    public CapturingMetaDataTable(List<SqlStatement> sqlStatements, DbSupport dbSupport, Table table) {
        super(dbSupport, table);
        this.sqlStatements = sqlStatements;
        this.dbSupport = dbSupport;
        this.table = table;
    }

    public void addAppliedMigration(AppliedMigration appliedMigration) {
        int calculateInstalledRank;
        MigrationVersion version = appliedMigration.getVersion();
        String versionStr = version == null ? null : version.toString();
        try {
            calculateInstalledRank = this.calculateInstalledRank();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        String sql = "INSERT INTO " + this.table + " (" + this.dbSupport.quote(new String[]{"installed_rank"}) + "," + this.dbSupport.quote(new String[]{"version"}) + "," + this.dbSupport.quote(new String[]{"description"}) + "," + this.dbSupport.quote(new String[]{"type"}) + "," + this.dbSupport.quote(new String[]{"script"}) + "," + this.dbSupport.quote(new String[]{"checksum"}) + "," + this.dbSupport.quote(new String[]{"installed_by"}) + "," + this.dbSupport.quote(new String[]{"execution_time"}) + "," + this.dbSupport.quote(new String[]{"success"}) + ")" + " VALUES (" + (calculateInstalledRank + appliedMigration.getInstalledRank()) + "," + "'" + versionStr + "'," + "'" + appliedMigration.getDescription() + "'," + "'" + appliedMigration.getType().name() + "'," + "'" + appliedMigration.getScript() + "'," + appliedMigration.getChecksum() + "," + this.dbSupport.getCurrentUserFunction() + "," + appliedMigration.getExecutionTime() + "," + appliedMigration.isSuccess() + ")";
        this.sqlStatements.add(new SqlStatement(0, sql, false));
    }

    private int calculateInstalledRank() throws SQLException {
        int currentMax = this.dbSupport.getJdbcTemplate().queryForInt("SELECT MAX(" + this.dbSupport.quote(new String[]{"installed_rank"}) + ") FROM " + this.table, new String[0]);
        return currentMax + 1;
    }
}

