/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.migration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.DbSupportFactory;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatement;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.jdbc.TransactionCallback;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.filesystem.FileSystemResource;
import org.killbill.billing.util.migration.CapturingMetaDataTable;
import org.killbill.billing.util.migration.CapturingSqlMigrationExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMigrateWithDryRun
extends DbMigrate {
    private static final Log LOG = LogFactory.getLog(DbMigrateWithDryRun.class);
    private final List<SqlStatement> sqlStatements;
    private final PlaceholderReplacer placeholderReplacer;
    private final String encoding;
    private final MigrationVersion target;
    private final DbSupport dbSupport;
    private final MetaDataTable metaDataTableForDryRun;
    private final Schema schema;
    private final MigrationResolver migrationResolver;
    private final Connection connectionMetaDataTable;
    private final Connection connectionUserObjects;
    private final boolean outOfOrder;
    private final FlywayCallback[] callbacks;
    private final DbSupport dbSupportUserObjects;

    public DbMigrateWithDryRun(List<SqlStatement> sqlStatements, PlaceholderReplacer placeholderReplacer, String encoding, Table metaDataDBTable, Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, MetaDataTable metaDataTable, Schema schema, MigrationResolver migrationResolver, MigrationVersion target, boolean ignoreFutureMigrations, boolean ignoreFailedFutureMigration, boolean outOfOrder, FlywayCallback[] callbacks) {
        super(connectionMetaDataTable, connectionUserObjects, dbSupport, metaDataTable, schema, migrationResolver, target, ignoreFutureMigrations, ignoreFailedFutureMigration, outOfOrder, callbacks);
        this.sqlStatements = sqlStatements;
        this.placeholderReplacer = placeholderReplacer;
        this.encoding = encoding;
        this.connectionMetaDataTable = connectionMetaDataTable;
        this.connectionUserObjects = connectionUserObjects;
        this.dbSupport = dbSupport;
        this.schema = schema;
        this.migrationResolver = migrationResolver;
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.callbacks = callbacks;
        this.dbSupportUserObjects = DbSupportFactory.createDbSupport((Connection)connectionUserObjects, (boolean)false);
        this.metaDataTableForDryRun = new CapturingMetaDataTable(sqlStatements, dbSupport, metaDataDBTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dryRunMigrate() throws FlywayException {
        try {
            for (final FlywayCallback callback : this.callbacks) {
                new TransactionTemplate(this.connectionUserObjects).execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction() throws SQLException {
                        DbMigrateWithDryRun.this.dbSupportUserObjects.changeCurrentSchemaTo(DbMigrateWithDryRun.this.schema);
                        callback.beforeMigrate(DbMigrateWithDryRun.this.connectionUserObjects);
                        return null;
                    }
                });
            }
            MigrationInfoServiceImpl infoService = new MigrationInfoServiceImpl(this.migrationResolver, this.metaDataTableForDryRun, this.target, this.outOfOrder, true, true);
            infoService.refresh();
            final MigrationInfoImpl[] pendingMigrations = infoService.pending();
            new TransactionTemplate(this.connectionMetaDataTable, false).execute((TransactionCallback)new TransactionCallback<Boolean>(){

                public Boolean doInTransaction() {
                    int i = 1;
                    for (MigrationInfoImpl migrationInfo : pendingMigrations) {
                        DbMigrateWithDryRun.this.applyMigration(i, migrationInfo);
                        ++i;
                    }
                    return true;
                }
            });
            for (final FlywayCallback callback : this.callbacks) {
                new TransactionTemplate(this.connectionUserObjects).execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction() throws SQLException {
                        DbMigrateWithDryRun.this.dbSupportUserObjects.changeCurrentSchemaTo(DbMigrateWithDryRun.this.schema);
                        callback.afterMigrate(DbMigrateWithDryRun.this.connectionUserObjects);
                        return null;
                    }
                });
            }
            int n = pendingMigrations.length;
            return n;
        }
        finally {
            this.dbSupportUserObjects.restoreCurrentSchema();
        }
    }

    private void applyMigration(int installedRnk, MigrationInfoImpl migration) {
        MigrationVersion version = migration.getVersion();
        String migrationText = version != null ? "schema " + this.schema + " to version " + version + " - " + migration.getDescription() : "schema " + this.schema + " with repeatable migration " + migration.getDescription();
        LOG.info("Migrating " + migrationText);
        FileSystemResource sqlScriptResource = new FileSystemResource(migration.getResolvedMigration().getPhysicalLocation());
        CapturingSqlMigrationExecutor migrationExecutor = new CapturingSqlMigrationExecutor(this.sqlStatements, this.dbSupport, (Resource)sqlScriptResource, this.placeholderReplacer, this.encoding);
        try {
            this.doMigrate((MigrationInfo)migration, migrationExecutor, migrationText);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to apply migration", (Throwable)e);
        }
        AppliedMigration appliedMigration = new AppliedMigration(installedRnk, version, migration.getDescription(), migration.getType(), migration.getScript(), migration.getResolvedMigration().getChecksum(), null, null, -1, true);
        this.metaDataTableForDryRun.addAppliedMigration(appliedMigration);
    }

    private void doMigrate(MigrationInfo migration, MigrationExecutor migrationExecutor, String migrationText) throws SQLException {
        for (FlywayCallback callback : this.callbacks) {
            this.dbSupportUserObjects.changeCurrentSchemaTo(this.schema);
            callback.beforeEachMigrate(this.connectionUserObjects, migration);
        }
        this.dbSupportUserObjects.changeCurrentSchemaTo(this.schema);
        migrationExecutor.execute(this.connectionUserObjects);
        LOG.debug("Successfully completed migration of " + migrationText);
        for (FlywayCallback callback : this.callbacks) {
            this.dbSupportUserObjects.changeCurrentSchemaTo(this.schema);
            callback.afterEachMigrate(this.connectionUserObjects, migration);
        }
    }
}

