/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.killbill.billing.osgi.api.PluginState;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.nodes.DefaultNodeCommandMetadata;
import org.killbill.billing.util.nodes.NodeCommandMetadata;
import org.killbill.billing.util.nodes.NodeCommandProperty;
import org.killbill.billing.util.nodes.NodeInfoMapper;
import org.killbill.billing.util.nodes.PluginNodeCommandMetadata;
import org.killbill.billing.util.nodes.SystemNodeCommandType;
import org.killbill.billing.util.nodes.json.NodeInfoModelJson;
import org.killbill.billing.util.nodes.json.PluginInfoModelJson;
import org.killbill.billing.util.nodes.json.PluginServiceInfoModelJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeInfoMapper
extends UtilTestSuiteNoDB {
    @Inject
    protected NodeInfoMapper nodeInfoMapper;

    @Test(groups={"fast"})
    public void testNodeInfoSerialization() throws Exception {
        PluginServiceInfoModelJson svc = new PluginServiceInfoModelJson("typeName", "registrationName");
        HashSet<PluginServiceInfoModelJson> services1 = new HashSet<PluginServiceInfoModelJson>();
        services1.add(svc);
        ArrayList<PluginInfoModelJson> pluginInfos = new ArrayList<PluginInfoModelJson>();
        PluginInfoModelJson info1 = new PluginInfoModelJson("sym1", "key1", "name1", "vers1", PluginState.STOPPED, Boolean.valueOf(true), services1);
        pluginInfos.add(info1);
        NodeInfoModelJson input = new NodeInfoModelJson("nodeName", this.clock.getUTCNow(), this.clock.getUTCNow(), "1.0", "1.0", "1.0", "1.0", "1.0", pluginInfos);
        String nodeInfoStr = this.nodeInfoMapper.serializeNodeInfo(input);
        NodeInfoModelJson res = this.nodeInfoMapper.deserializeNodeInfo(nodeInfoStr);
        Assert.assertEquals((Object)res, (Object)input);
    }

    @Test(groups={"fast"})
    public void testNodeSystemCommandSerialization() throws Exception {
        NodeCommandProperty prop = new NodeCommandProperty("something", (Object)"nothing");
        PluginNodeCommandMetadata nodeCommandMetadata = new PluginNodeCommandMetadata("foo", "key1", "1.2.3", (List)ImmutableList.of((Object)prop));
        String nodeCmdStr = this.nodeInfoMapper.serializeNodeCommand((NodeCommandMetadata)nodeCommandMetadata);
        NodeCommandMetadata res = this.nodeInfoMapper.deserializeNodeCommand(nodeCmdStr, SystemNodeCommandType.START_PLUGIN.name());
        Assert.assertTrue((boolean)(res instanceof PluginNodeCommandMetadata));
        Assert.assertEquals((String)((PluginNodeCommandMetadata)res).getPluginName(), (String)nodeCommandMetadata.getPluginName());
        Assert.assertEquals((String)((PluginNodeCommandMetadata)res).getPluginVersion(), (String)nodeCommandMetadata.getPluginVersion());
        Assert.assertEquals((int)res.getProperties().size(), (int)1);
        Assert.assertEquals((String)((NodeCommandProperty)res.getProperties().get(0)).getKey(), (String)"something");
        Assert.assertEquals((Object)((NodeCommandProperty)res.getProperties().get(0)).getValue(), (Object)"nothing");
    }

    @Test(groups={"fast"})
    public void testNodeCommandSerialization() throws Exception {
        NodeCommandProperty prop = new NodeCommandProperty("something", (Object)"nothing");
        DefaultNodeCommandMetadata nodeCommandMetadata = new DefaultNodeCommandMetadata((List)ImmutableList.of((Object)prop));
        String nodeCmdStr = this.nodeInfoMapper.serializeNodeCommand((NodeCommandMetadata)nodeCommandMetadata);
        NodeCommandMetadata res = this.nodeInfoMapper.deserializeNodeCommand(nodeCmdStr, "opaque type");
        Assert.assertTrue((boolean)(res instanceof NodeCommandMetadata));
        Assert.assertEquals((int)res.getProperties().size(), (int)1);
        Assert.assertEquals((String)((NodeCommandProperty)res.getProperties().get(0)).getKey(), (String)"something");
        Assert.assertEquals((Object)((NodeCommandProperty)res.getProperties().get(0)).getValue(), (Object)"nothing");
    }
}

