/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.nodes.dao;

import java.util.List;
import org.joda.time.DateTime;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.nodes.dao.NodeInfoModelDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeInfoDao
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        DateTime now = this.clock.getUTCNow();
        DateTime initialBootTime1 = this.clock.getUTCNow().minusDays(1);
        NodeInfoModelDao node1 = new NodeInfoModelDao(Long.valueOf(-1L), "node1", initialBootTime1, now, "nodeInfo", Boolean.valueOf(true));
        this.nodeInfoDao.create(node1);
        List all = this.nodeInfoDao.getAll();
        Assert.assertEquals((int)all.size(), (int)1);
        Assert.assertEquals(all.get(0), (Object)node1);
        DateTime secondBootTime1 = this.clock.getUTCNow();
        now = this.clock.getUTCNow().plusSeconds(1);
        NodeInfoModelDao newNode1 = new NodeInfoModelDao(Long.valueOf(-1L), "node1", secondBootTime1, now, "nodeInfo", Boolean.valueOf(true));
        this.nodeInfoDao.create(newNode1);
        all = this.nodeInfoDao.getAll();
        Assert.assertEquals((int)all.size(), (int)1);
        Assert.assertEquals(all.get(0), (Object)newNode1);
        DateTime initialBootTime2 = this.clock.getUTCNow();
        NodeInfoModelDao node2 = new NodeInfoModelDao(Long.valueOf(-1L), "node2", initialBootTime2, now, "nodeInfo", Boolean.valueOf(true));
        this.nodeInfoDao.create(node2);
        all = this.nodeInfoDao.getAll();
        Assert.assertEquals((int)all.size(), (int)2);
        Assert.assertEquals(all.get(0), (Object)newNode1);
        Assert.assertEquals(all.get(1), (Object)node2);
        NodeInfoModelDao newNode2 = new NodeInfoModelDao(Long.valueOf(-1L), "node2", initialBootTime2, now, "nodeInfo2", Boolean.valueOf(true));
        this.nodeInfoDao.updateNodeInfo(newNode2.getNodeName(), newNode2.getNodeInfo());
        all = this.nodeInfoDao.getAll();
        Assert.assertEquals((int)all.size(), (int)2);
        Assert.assertEquals(all.get(0), (Object)newNode1);
        Assert.assertEquals(all.get(1), (Object)newNode2);
    }
}

