/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.glue.CacheModule;
import org.killbill.billing.util.glue.KillBillShiroAopModule;
import org.killbill.billing.util.glue.TestSecurityModuleNoDB;
import org.killbill.billing.util.glue.TestUtilModuleNoDB;
import org.mockito.Mockito;
import org.skife.jdbi.v2.IDBI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPermissionAnnotationMethodInterceptor
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testAOPForClass() throws Exception {
        AopTester simpleTester = new AopTester();
        try {
            simpleTester.createRefund();
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.configureShiro();
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new TestUtilModuleNoDB.ShiroModuleNoDB(this.configSource), new KillBillShiroAopModule(), new TestSecurityModuleNoDB(this.configSource), new CacheModule(this.configSource), new AbstractModule(){

            protected void configure() {
                this.bind(IDBI.class).toInstance(Mockito.mock(IDBI.class));
                this.bind(TenantInternalApi.class).toInstance(Mockito.mock(TenantInternalApi.class));
                this.bind(NonEntityDao.class).toInstance(Mockito.mock(NonEntityDao.class));
            }
        }});
        AopTester aopedTester = (AopTester)injector.getInstance(AopTester.class);
        this.verifyAopedTester(aopedTester);
    }

    @Test(groups={"fast"})
    public void testAOPForInterface() throws Exception {
        AopTesterImpl simpleTester = new AopTesterImpl();
        try {
            simpleTester.createRefund();
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.configureShiro();
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new TestUtilModuleNoDB.ShiroModuleNoDB(this.configSource), new KillBillShiroAopModule(), new TestSecurityModuleNoDB(this.configSource), new CacheModule(this.configSource), new AbstractModule(){

            public void configure() {
                this.bind(IDBI.class).toInstance(Mockito.mock(IDBI.class));
                this.bind(IAopTester.class).to(AopTesterImpl.class).asEagerSingleton();
                this.bind(TenantInternalApi.class).toInstance(Mockito.mock(TenantInternalApi.class));
                this.bind(NonEntityDao.class).toInstance(Mockito.mock(NonEntityDao.class));
            }
        }});
        IAopTester aopedTester = (IAopTester)injector.getInstance(IAopTester.class);
        this.verifyAopedTester(aopedTester);
    }

    private void verifyAopedTester(IAopTester aopedTester) {
        this.logout();
        try {
            aopedTester.createRefund();
            Assert.fail();
        }
        catch (UnauthenticatedException unauthenticatedException) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.login("pierre");
        try {
            aopedTester.createRefund();
            Assert.fail();
        }
        catch (AuthorizationException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        this.login("stephane");
        aopedTester.createRefund();
    }

    @Singleton
    public static class AopTester
    implements IAopTester {
        @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND})
        public void createRefund() {
        }
    }

    public static class AopTesterImpl
    implements IAopTester {
        public void createRefund() {
        }
    }

    public static interface IAopTester {
        @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND})
        public void createRefund();
    }
}

