/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.api;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import org.killbill.billing.security.Permission;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.security.api.DefaultSecurityApi;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultSecurityApi
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testRetrievePermissions() throws Exception {
        this.configureShiro();
        DefaultSecurityApi securityApi = new DefaultSecurityApi(null);
        this.logout();
        Set anonsPermissions = securityApi.getCurrentUserPermissions((TenantContext)this.callContext);
        Assert.assertEquals((int)anonsPermissions.size(), (int)0, (String)("Invalid permissions: " + anonsPermissions));
        this.login("pierre");
        Set pierresPermissions = securityApi.getCurrentUserPermissions((TenantContext)this.callContext);
        Assert.assertEquals((int)pierresPermissions.size(), (int)2);
        Assert.assertTrue((boolean)pierresPermissions.containsAll((Collection<?>)ImmutableList.of((Object)Permission.INVOICE_CAN_CREDIT, (Object)Permission.INVOICE_CAN_ITEM_ADJUST)));
        this.login("stephane");
        Set stephanesPermissions = securityApi.getCurrentUserPermissions((TenantContext)this.callContext);
        Assert.assertEquals((int)stephanesPermissions.size(), (int)1);
        Assert.assertTrue((boolean)stephanesPermissions.containsAll((Collection<?>)ImmutableList.of((Object)Permission.PAYMENT_CAN_REFUND)));
    }
}

