/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.security.shiro.dao.JDBCSessionDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJDBCSessionDao
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testH2AndInvalidSessionId() {
        JDBCSessionDao jdbcSessionDao = new JDBCSessionDao(this.dbi);
        SimpleSession session = this.createSession();
        jdbcSessionDao.doCreate((Session)session);
        Assert.assertNull((Object)jdbcSessionDao.doReadSession((Serializable)UUID.randomUUID()));
    }

    @Test(groups={"slow"})
    public void testCRUD() throws Exception {
        JDBCSessionDao jdbcSessionDao = new JDBCSessionDao(this.dbi);
        SimpleSession session = this.createSession();
        Assert.assertNull((Object)jdbcSessionDao.doReadSession(session.getId()));
        Serializable sessionId = jdbcSessionDao.doCreate((Session)session);
        Session retrievedSession = jdbcSessionDao.doReadSession(sessionId);
        Assert.assertEquals((Object)retrievedSession, (Object)session);
        String newHost = UUID.randomUUID().toString();
        Assert.assertNotEquals((Object)retrievedSession.getHost(), (Object)newHost);
        session.setHost(newHost);
        jdbcSessionDao.doUpdate((Session)session);
        Assert.assertEquals((String)jdbcSessionDao.doReadSession(sessionId).getHost(), (String)newHost);
        jdbcSessionDao.doDelete((Session)session);
        Assert.assertNull((Object)jdbcSessionDao.doReadSession(session.getId()));
    }

    private SimpleSession createSession() {
        SimpleSession simpleSession = new SimpleSession();
        simpleSession.setStartTimestamp(new Date(System.currentTimeMillis() - 5000L));
        simpleSession.setLastAccessTime(new Date(System.currentTimeMillis()));
        simpleSession.setTimeout(493934L);
        simpleSession.setHost(UUID.randomUUID().toString());
        simpleSession.setAttribute((Object)UUID.randomUUID().toString(), (Object)Short.MIN_VALUE);
        simpleSession.setAttribute((Object)UUID.randomUUID().toString(), (Object)Integer.MIN_VALUE);
        simpleSession.setAttribute((Object)UUID.randomUUID().toString(), (Object)Long.MIN_VALUE);
        simpleSession.setAttribute((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID().toString());
        simpleSession.setAttribute((Object)UUID.randomUUID().toString(), (Object)UUID.randomUUID());
        simpleSession.setAttribute((Object)UUID.randomUUID().toString(), (Object)new Date(1242L));
        return simpleSession;
    }
}

