/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.realm;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.apache.shiro.util.ThreadContext;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.SecurityApiException;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.security.shiro.realm.KillBillJdbcRealm;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestKillBillJdbcRealm
extends UtilTestSuiteWithEmbeddedDB {
    private SecurityManager securityManager;

    @Override
    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        KillBillJdbcRealm realm = new KillBillJdbcRealm(this.helper.getDataSource(), this.securityConfig);
        this.securityManager = new DefaultSecurityManager((Realm)realm);
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    @Override
    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        super.afterMethod();
        ThreadContext.unbindSecurityManager();
    }

    @Test(groups={"slow"})
    public void testAuthentication() throws SecurityApiException {
        String username = "toto";
        String password = "supperCompli43cated";
        this.securityApi.addRoleDefinition("root", (List)ImmutableList.of((Object)"*"), this.callContext);
        this.securityApi.addUserRoles("toto", "supperCompli43cated", (List)ImmutableList.of((Object)"root"), this.callContext);
        DelegatingSubject subject = new DelegatingSubject(this.securityManager);
        UsernamePasswordToken goodToken = new UsernamePasswordToken("toto", "supperCompli43cated");
        this.securityManager.login((Subject)subject, (AuthenticationToken)goodToken);
        Assert.assertTrue((boolean)true);
        try {
            UsernamePasswordToken badToken = new UsernamePasswordToken("toto", "somethingelse");
            this.securityManager.login((Subject)subject, (AuthenticationToken)badToken);
            Assert.assertTrue((boolean)true);
            this.securityManager.logout((Subject)subject);
            this.securityManager.login((Subject)subject, (AuthenticationToken)badToken);
            Assert.fail((String)"Should not succeed to login with an incorrect password");
        }
        catch (AuthenticationException badToken) {
            // empty catch block
        }
        String newPassword = "suppersimple";
        this.securityApi.updateUserPassword("toto", "suppersimple", this.callContext);
        try {
            UsernamePasswordToken notGoodTokenAnyLonger = goodToken;
            this.securityManager.login((Subject)subject, (AuthenticationToken)notGoodTokenAnyLonger);
            Assert.fail((String)"Should not succeed to login with an incorrect password");
        }
        catch (AuthenticationException notGoodTokenAnyLonger) {
            // empty catch block
        }
        UsernamePasswordToken newGoodToken = new UsernamePasswordToken("toto", "suppersimple");
        this.securityManager.login((Subject)subject, (AuthenticationToken)newGoodToken);
        Assert.assertTrue((boolean)true);
        this.securityManager.logout((Subject)subject);
        this.securityApi.invalidateUser("toto", this.callContext);
        try {
            UsernamePasswordToken notGoodTokenAnyLonger = goodToken;
            this.securityManager.login((Subject)subject, (AuthenticationToken)notGoodTokenAnyLonger);
            Assert.fail((String)"Should not succeed to login with an incorrect password");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    @Test(groups={"slow"})
    public void testEmptyPermissions() throws SecurityApiException {
        this.securityApi.addRoleDefinition("sanity1", null, this.callContext);
        this.validateUserRoles(this.securityApi.getRoleDefinition("sanity1", (TenantContext)this.callContext), (List<String>)ImmutableList.of());
        this.securityApi.addRoleDefinition("sanity2", (List)ImmutableList.of(), this.callContext);
        this.validateUserRoles(this.securityApi.getRoleDefinition("sanity2", (TenantContext)this.callContext), (List<String>)ImmutableList.of());
    }

    @Test(groups={"slow"})
    public void testInvalidPermissions() {
        this.testInvalidPermissionScenario((List<String>)ImmutableList.of((Object)"foo"));
        this.testInvalidPermissionScenario((List<String>)ImmutableList.of((Object)"account:garbage"));
        this.testInvalidPermissionScenario((List<String>)ImmutableList.of((Object)"tag:delete_tag_definition", (Object)"account:hsgdsgdjsgd"));
        this.testInvalidPermissionScenario((List<String>)ImmutableList.of((Object)"account:credit:vvvv"));
    }

    @Test(groups={"slow"})
    public void testSanityOfPermissions() throws SecurityApiException {
        this.securityApi.addRoleDefinition("sanity1", (List)ImmutableList.of((Object)"account:*", (Object)"*"), this.callContext);
        this.validateUserRoles(this.securityApi.getRoleDefinition("sanity1", (TenantContext)this.callContext), (List<String>)ImmutableList.of((Object)"*"));
        this.securityApi.addRoleDefinition("sanity2", (List)ImmutableList.of((Object)"account:charge", (Object)"account:charge"), this.callContext);
        this.validateUserRoles(this.securityApi.getRoleDefinition("sanity2", (TenantContext)this.callContext), (List<String>)ImmutableList.of((Object)"account:charge"));
        this.securityApi.addRoleDefinition("sanity3", (List)ImmutableList.of((Object)"account:charge", (Object)"account:credit", (Object)"account:*", (Object)"invoice:*"), this.callContext);
        this.validateUserRoles(this.securityApi.getRoleDefinition("sanity3", (TenantContext)this.callContext), (List<String>)ImmutableList.of((Object)"account:*", (Object)"invoice:*"));
    }

    @Test(groups={"slow"})
    public void testAuthorization() throws SecurityApiException {
        String username = "i like";
        String password = "c0ff33";
        this.securityApi.addRoleDefinition("restricted", (List)ImmutableList.of((Object)"account:*", (Object)"invoice", (Object)"tag:create_tag_definition"), this.callContext);
        this.securityApi.addUserRoles("i like", "c0ff33", (List)ImmutableList.of((Object)"restricted"), this.callContext);
        UsernamePasswordToken goodToken = new UsernamePasswordToken("i like", "c0ff33");
        Subject subject = this.securityManager.login(null, (AuthenticationToken)goodToken);
        subject.checkPermission(Permission.ACCOUNT_CAN_CHARGE.toString());
        subject.checkPermission(Permission.INVOICE_CAN_CREDIT.toString());
        subject.checkPermission(Permission.TAG_CAN_CREATE_TAG_DEFINITION.toString());
        try {
            subject.checkPermission(Permission.TAG_CAN_DELETE_TAG_DEFINITION.toString());
            Assert.fail((String)"Subject should not have rights to delete tag definitions");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        subject.logout();
        this.securityApi.addRoleDefinition("newRestricted", (List)ImmutableList.of((Object)"account:*", (Object)"invoice", (Object)"tag:delete_tag_definition"), this.callContext);
        this.securityApi.updateUserRoles("i like", (List)ImmutableList.of((Object)"newRestricted"), this.callContext);
        Subject newSubject = this.securityManager.login(null, (AuthenticationToken)goodToken);
        newSubject.checkPermission(Permission.ACCOUNT_CAN_CHARGE.toString());
        newSubject.checkPermission(Permission.INVOICE_CAN_CREDIT.toString());
        newSubject.checkPermission(Permission.TAG_CAN_DELETE_TAG_DEFINITION.toString());
        try {
            newSubject.checkPermission(Permission.TAG_CAN_CREATE_TAG_DEFINITION.toString());
            Assert.fail((String)"Subject should not have rights to create tag definitions");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    private void testInvalidPermissionScenario(List<String> permissions) {
        try {
            this.securityApi.addRoleDefinition("failed", permissions, this.callContext);
            Assert.fail((String)("Should fail permissions " + permissions + " were invalid"));
        }
        catch (SecurityApiException expected) {
            Assert.assertEquals((int)expected.getCode(), (int)ErrorCode.SECURITY_INVALID_PERMISSIONS.getCode());
        }
    }

    private void validateUserRoles(List<String> roles, List<String> expectedRoles) {
        Assert.assertEquals((int)roles.size(), (int)expectedRoles.size());
        for (final String cur : expectedRoles) {
            boolean found = false;
            if (Iterables.tryFind(roles, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return input.equals(cur);
                }
            }).orNull() != null) {
                found = true;
            }
            Assert.assertTrue((boolean)found, (String)("Cannot find role " + cur));
        }
    }
}

