/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.realm;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.security.shiro.realm.KillBillJndiLdapRealm;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.SimplePropertyConfigSource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestKillBillJndiLdapRealm
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testCheckConfiguration() throws Exception {
        Map permission = this.killBillJndiLdapRealm.getPermissionsByGroup();
        Assert.assertEquals((int)((Collection)permission.get("admin")).size(), (int)1);
        Assert.assertEquals((String)((String)((Collection)permission.get("admin")).iterator().next()), (String)"*:*");
        Assert.assertEquals((int)((Collection)permission.get("finance")).size(), (int)2);
        Assert.assertEquals((Set)Sets.newHashSet((Iterable)((Iterable)permission.get("finance"))), (Set)Sets.newHashSet((Object[])new String[]{"invoice:*", "payment:*"}));
        Assert.assertEquals((int)((Collection)permission.get("support")).size(), (int)2);
        Assert.assertEquals((Set)Sets.newHashSet((Iterable)((Iterable)permission.get("support"))), (Set)Sets.newHashSet((Object[])new String[]{"entitlement:*", "invoice:item_adjust"}));
    }

    @Test(groups={"external"}, enabled=false)
    public void testCheckLDAPConnection() throws Exception {
        Properties props = new Properties();
        props.setProperty("org.killbill.security.ldap.userDnTemplate", "uid={0},ou=users,dc=mycompany,dc=com");
        props.setProperty("org.killbill.security.ldap.searchBase", "ou=groups,dc=mycompany,dc=com");
        props.setProperty("org.killbill.security.ldap.groupSearchFilter", "memberOf=uid={0},ou=users,dc=mycompany,dc=com");
        props.setProperty("org.killbill.security.ldap.groupNameId", "cn");
        props.setProperty("org.killbill.security.ldap.url", "ldap://ldap:389");
        props.setProperty("org.killbill.security.ldap.disableSSLCheck", "true");
        props.setProperty("org.killbill.security.ldap.systemUsername", "cn=root");
        props.setProperty("org.killbill.security.ldap.systemPassword", "password");
        props.setProperty("org.killbill.security.ldap.authenticationMechanism", "simple");
        props.setProperty("org.killbill.security.ldap.permissionsByGroup", "support-group: entitlement:*\nfinance-group: invoice:*, payment:*\nops-group: *:*");
        SimplePropertyConfigSource customConfigSource = new SimplePropertyConfigSource(props);
        SecurityConfig securityConfig = (SecurityConfig)new ConfigurationObjectFactory((ConfigSource)customConfigSource).build(SecurityConfig.class);
        KillBillJndiLdapRealm ldapRealm = new KillBillJndiLdapRealm(securityConfig);
        String username = "pierre";
        String password = "password";
        UsernamePasswordToken token = new UsernamePasswordToken("pierre", "password");
        AuthenticationInfo authenticationInfo = ldapRealm.getAuthenticationInfo((AuthenticationToken)token);
        System.out.println(authenticationInfo);
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)"pierre", "pierre");
        AuthorizationInfo authorizationInfo = ldapRealm.queryForAuthorizationInfo((PrincipalCollection)principals, ldapRealm.getContextFactory());
        System.out.println("Roles: " + authorizationInfo.getRoles());
        System.out.println("Permissions: " + authorizationInfo.getStringPermissions());
    }
}

