/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.security.shiro.realm;

import java.util.Properties;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.config.definition.SecurityConfig;
import org.killbill.billing.util.security.shiro.realm.KillBillOktaRealm;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.SimplePropertyConfigSource;
import org.testng.annotations.Test;

public class TestKillBillOktaRealm
extends UtilTestSuiteNoDB {
    @Test(groups={"external"}, enabled=false)
    public void testCheckOktaConnection() throws Exception {
        Properties props = new Properties();
        props.setProperty("org.killbill.security.okta.url", "https://dev-XXXXXX.oktapreview.com");
        props.setProperty("org.killbill.security.okta.apiToken", "YYYYYY");
        props.setProperty("org.killbill.security.okta.permissionsByGroup", "support-group: entitlement:*\nfinance-group: invoice:*, payment:*\nops-group: *:*");
        SimplePropertyConfigSource customConfigSource = new SimplePropertyConfigSource(props);
        SecurityConfig securityConfig = (SecurityConfig)new ConfigurationObjectFactory((ConfigSource)customConfigSource).build(SecurityConfig.class);
        KillBillOktaRealm oktaRealm = new KillBillOktaRealm(securityConfig);
        String username = "pierre";
        String password = "password";
        UsernamePasswordToken token = new UsernamePasswordToken("pierre", "password");
        AuthenticationInfo authenticationInfo = oktaRealm.getAuthenticationInfo((AuthenticationToken)token);
        System.out.println(authenticationInfo);
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)"pierre", "pierre");
        AuthorizationInfo authorizationInfo = oktaRealm.doGetAuthorizationInfo((PrincipalCollection)principals);
        System.out.println("Roles: " + authorizationInfo.getRoles());
        System.out.println("Permissions: " + authorizationInfo.getStringPermissions());
    }
}

