/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.DefaultTagDefinition;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultTagDefinition
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testDefaultTagDefinition() throws TagApiException, TagDefinitionApiException {
        DefaultTagDefinition def1 = new DefaultTagDefinition(UUID.randomUUID(), "foo", "nothing", Boolean.valueOf(false));
        Assert.assertFalse((boolean)def1.getApplicableObjectTypes().isEmpty());
        Assert.assertEquals((Collection)ImmutableList.copyOf((Object[])ObjectType.values()), (Collection)def1.getApplicableObjectTypes());
        for (ControlTagType cur : ControlTagType.values()) {
            DefaultTagDefinition curDef = new DefaultTagDefinition(cur.getId(), cur.name(), cur.getDescription(), Boolean.valueOf(true));
            Assert.assertFalse((boolean)curDef.getApplicableObjectTypes().isEmpty());
            Assert.assertEquals((Collection)curDef.getApplicableObjectTypes(), (Collection)cur.getApplicableObjectTypes());
        }
        try {
            new DefaultTagDefinition(UUID.randomUUID(), "bar", "nothing again", Boolean.valueOf(true));
            Assert.fail((String)"Not a control tag type");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

