/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag;

import java.util.List;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.DefaultControlTag;
import org.killbill.billing.util.tag.DescriptiveTag;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTagStore
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testTagCreationAndRetrieval() throws TagApiException, TagDefinitionApiException {
        UUID accountId = UUID.randomUUID();
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        this.tagDefinitionDao.create("tag1", "First tag", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao testTagDefinition = this.tagDefinitionDao.create("testTagDefinition", "Second tag", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        DescriptiveTag tag = new DescriptiveTag(testTagDefinition.getId(), ObjectType.ACCOUNT, accountId, this.clock.getUTCNow());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.create(new TagModelDao((Tag)tag), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        TagModelDao savedTag = (TagModelDao)this.tagDao.getById(tag.getId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)savedTag.getTagDefinitionId(), (Object)tag.getTagDefinitionId());
        Assert.assertEquals((Object)savedTag.getId(), (Object)tag.getId());
    }

    @Test(groups={"slow"})
    public void testControlTagCreation() throws TagApiException {
        UUID accountId = UUID.randomUUID();
        DefaultControlTag tag = new DefaultControlTag(ControlTagType.AUTO_INVOICING_OFF, ObjectType.ACCOUNT, accountId, this.clock.getUTCNow());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.create(new TagModelDao((Tag)tag), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        TagModelDao savedTag = (TagModelDao)this.tagDao.getById(tag.getId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)savedTag.getTagDefinitionId(), (Object)tag.getTagDefinitionId());
        Assert.assertEquals((Object)savedTag.getId(), (Object)tag.getId());
    }

    @Test(groups={"slow"}, expectedExceptions={TagDefinitionApiException.class})
    public void testTagDefinitionCreationWithControlTagName() throws TagDefinitionApiException {
        String definitionName = ControlTagType.AUTO_PAY_OFF.toString();
        this.tagDefinitionDao.create(definitionName, "This should break", (InternalCallContext)this.internalCallContext);
    }

    @Test(groups={"slow"})
    public void testTagDefinitionDeletionForUnusedDefinition() throws TagDefinitionApiException {
        String definitionName = "TestTag1234";
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        this.tagDefinitionDao.create("TestTag1234", "Some test tag", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        TagDefinitionModelDao tagDefinition = this.tagDefinitionDao.getByName("TestTag1234", (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)tagDefinition);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        this.tagDefinitionDao.deleteById(tagDefinition.getId(), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        tagDefinition = this.tagDefinitionDao.getByName("TestTag1234", (InternalTenantContext)this.internalCallContext);
        Assert.assertNull((Object)tagDefinition);
    }

    @Test(groups={"slow"}, expectedExceptions={TagDefinitionApiException.class})
    public void testTagDefinitionDeletionForDefinitionInUse() throws TagDefinitionApiException, TagApiException {
        String definitionName = "TestTag12345";
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        this.tagDefinitionDao.create("TestTag12345", "Some test tag", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        TagDefinitionModelDao tagDefinition = this.tagDefinitionDao.getByName("TestTag12345", (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)tagDefinition);
        UUID objectId = UUID.randomUUID();
        DescriptiveTag tag = new DescriptiveTag(tagDefinition.getId(), ObjectType.ACCOUNT, objectId, this.internalCallContext.getCreatedDate());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.create(new TagModelDao((Tag)tag), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.tagDefinitionDao.deleteById(tagDefinition.getId(), (InternalCallContext)this.internalCallContext);
    }

    @Test(groups={"slow"})
    public void testDeleteTagBeforeDeleteTagDefinition() throws TagDefinitionApiException, TagApiException {
        String definitionName = "TestTag1234567";
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        this.tagDefinitionDao.create("TestTag1234567", "Some test tag", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        TagDefinitionModelDao tagDefinition = this.tagDefinitionDao.getByName("TestTag1234567", (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)tagDefinition);
        UUID objectId = UUID.randomUUID();
        DescriptiveTag tag = new DescriptiveTag(tagDefinition.getId(), ObjectType.ACCOUNT, objectId, this.internalCallContext.getCreatedDate());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.create(new TagModelDao((Tag)tag), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.deleteTag(objectId, ObjectType.ACCOUNT, tagDefinition.getId(), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        this.tagDefinitionDao.deleteById(tagDefinition.getId(), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
    }

    @Test(groups={"slow"})
    public void testGetTagDefinitions() {
        List definitionList = this.tagDefinitionDao.getTagDefinitions(false, (InternalTenantContext)this.internalCallContext);
        Assert.assertTrue((definitionList.size() >= ControlTagType.values().length ? 1 : 0) != 0);
    }
}

