/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.api;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.mockito.Mockito;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultTagUserApi
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testSaveTagWithAccountRecordId() throws Exception {
        final UUID accountId = UUID.randomUUID();
        final Long accountRecordId = 19384012L;
        ImmutableAccountData immutableAccountData = (ImmutableAccountData)Mockito.mock(ImmutableAccountData.class);
        Mockito.when((Object)this.immutableAccountInternalApi.getImmutableAccountDataByRecordId((Long)Mockito.eq((Object)accountRecordId), (InternalTenantContext)Mockito.any())).thenReturn((Object)immutableAccountData);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("insert into accounts (record_id, id, email, name, first_name_length, time_zone, is_notified_for_invoices, created_date, created_by, updated_date, updated_by) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{accountRecordId, accountId.toString(), "yo@t.com", "toto", 4, "UTC", false, new Date(), "i", new Date(), "j"});
                return null;
            }
        });
        this.checkPagination(0L);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagUserApi.addTags(accountId, ObjectType.ACCOUNT, (Collection)ImmutableList.of((Object)ControlTagType.WRITTEN_OFF.getId()), this.callContext);
        this.assertListenerStatus();
        this.checkPagination(1L);
        List tags = this.tagUserApi.getTagsForObject(accountId, ObjectType.ACCOUNT, true, (TenantContext)this.callContext);
        Assert.assertEquals((int)tags.size(), (int)1);
        Assert.assertEquals((Object)((Tag)tags.get(0)).getTagDefinitionId(), (Object)ControlTagType.WRITTEN_OFF.getId());
        Assert.assertEquals((Object)((Tag)tags.get(0)).getObjectId(), (Object)accountId);
        Assert.assertEquals((Object)((Tag)tags.get(0)).getObjectType(), (Object)ObjectType.ACCOUNT);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                List values = handle.select("select account_record_id from tags where object_id = ?", new Object[]{accountId.toString()});
                Assert.assertEquals((int)values.size(), (int)1);
                Assert.assertEquals((int)((Map)values.get(0)).keySet().size(), (int)1);
                Assert.assertEquals((Object)Long.valueOf(((Map)values.get(0)).get("account_record_id").toString()), (Object)accountRecordId);
                return null;
            }
        });
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagUserApi.removeTags(accountId, ObjectType.ACCOUNT, (Collection)ImmutableList.of((Object)ControlTagType.WRITTEN_OFF.getId()), this.callContext);
        this.assertListenerStatus();
        List remainingTags = this.tagUserApi.getTagsForObject(accountId, ObjectType.ACCOUNT, false, (TenantContext)this.callContext);
        Assert.assertEquals((int)remainingTags.size(), (int)0);
        this.checkPagination(0L);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagUserApi.addTags(accountId, ObjectType.ACCOUNT, (Collection)ImmutableList.of((Object)ControlTagType.WRITTEN_OFF.getId()), this.callContext);
        this.assertListenerStatus();
        remainingTags = this.tagUserApi.getTagsForObject(accountId, ObjectType.ACCOUNT, false, (TenantContext)this.callContext);
        Assert.assertEquals((int)remainingTags.size(), (int)1);
        this.checkPagination(1L);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagUserApi.removeTags(accountId, ObjectType.ACCOUNT, (Collection)ImmutableList.of((Object)ControlTagType.WRITTEN_OFF.getId()), this.callContext);
        this.assertListenerStatus();
        remainingTags = this.tagUserApi.getTagsForObject(accountId, ObjectType.ACCOUNT, false, (TenantContext)this.callContext);
        Assert.assertEquals((int)remainingTags.size(), (int)0);
        this.checkPagination(0L);
    }

    private void checkPagination(long nbRecords) {
        Pagination foundTags = this.tagUserApi.searchTags("ACCOUNT", Long.valueOf(0L), Long.valueOf(nbRecords + 1L), (TenantContext)this.callContext);
        Assert.assertEquals((boolean)foundTags.iterator().hasNext(), (nbRecords > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)foundTags.getMaxNbRecords(), (Object)nbRecords);
        Assert.assertEquals((Object)foundTags.getTotalNbRecords(), (Object)nbRecords);
        Pagination gotTags = this.tagUserApi.getTags(Long.valueOf(0L), Long.valueOf(nbRecords + 1L), (TenantContext)this.callContext);
        Assert.assertEquals((boolean)gotTags.iterator().hasNext(), (nbRecords > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)gotTags.getMaxNbRecords(), (Object)nbRecords);
        Assert.assertEquals((Object)gotTags.getTotalNbRecords(), (Object)nbRecords);
    }
}

