/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.api;

import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.billing.util.tag.api.DefaultTagUserApi;
import org.killbill.billing.util.tag.dao.TagDao;
import org.killbill.billing.util.tag.dao.TagDefinitionDao;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultTagUserApiWithMockDao
extends UtilTestSuiteNoDB {
    private DefaultTagUserApi tagUserApi;
    private TagDefinitionDao tagDefinitionDao;
    private CallContext context;

    @BeforeMethod(groups={"fast"})
    public void setUp() throws Exception {
        TagDao tagDao = (TagDao)Mockito.mock(TagDao.class);
        InternalCallContextFactory internalCallContextFactory = (InternalCallContextFactory)Mockito.mock(InternalCallContextFactory.class);
        this.tagDefinitionDao = (TagDefinitionDao)Mockito.mock(TagDefinitionDao.class);
        this.tagUserApi = new DefaultTagUserApi(internalCallContextFactory, this.tagDefinitionDao, tagDao);
        this.context = (CallContext)Mockito.mock(DefaultCallContext.class);
    }

    @Test(groups={"fast"}, expectedExceptions={TagDefinitionApiException.class}, expectedExceptionsMessageRegExp="The tag definition name must be in lowercase .*")
    public void testCreateTagDefinitionWithMiddleUpperCase() throws Exception {
        this.tagUserApi.createTagDefinition("inVaLid", "description", this.context);
    }

    @Test(groups={"fast"}, expectedExceptions={TagDefinitionApiException.class}, expectedExceptionsMessageRegExp="The tag definition name must be in lowercase .*")
    public void testCreateTagDefinitionWithFrontUpperCase() throws Exception {
        this.tagUserApi.createTagDefinition("Invalid", "description", this.context);
    }

    @Test(groups={"fast"}, expectedExceptions={TagDefinitionApiException.class}, expectedExceptionsMessageRegExp="The tag definition name must be in lowercase .*")
    public void testCreateTagDefinitionWithBackUpperCase() throws Exception {
        this.tagUserApi.createTagDefinition("invaliD", "description", this.context);
    }

    @Test(groups={"fast"})
    public void testCreateTagDefinitionWithLowerCase() throws Exception {
        String tagDefinitionName = "lowercase";
        TagDefinitionModelDao tagDefinitionModelDao = new TagDefinitionModelDao();
        tagDefinitionModelDao.setName("lowercase");
        Mockito.when((Object)this.tagDefinitionDao.create(Mockito.anyString(), Mockito.anyString(), (InternalCallContext)Mockito.any(InternalCallContext.class))).thenReturn((Object)tagDefinitionModelDao);
        TagDefinition tagDefinition = this.tagUserApi.createTagDefinition("lowercase", "description", this.context);
        Assert.assertEquals((String)"lowercase", (String)tagDefinition.getName());
    }
}

