/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.api.user;

import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.events.ControlTagCreationInternalEvent;
import org.killbill.billing.events.ControlTagDefinitionCreationInternalEvent;
import org.killbill.billing.events.ControlTagDefinitionDeletionInternalEvent;
import org.killbill.billing.events.ControlTagDeletionInternalEvent;
import org.killbill.billing.events.TagDefinitionInternalEvent;
import org.killbill.billing.events.TagInternalEvent;
import org.killbill.billing.events.UserTagCreationInternalEvent;
import org.killbill.billing.events.UserTagDefinitionCreationInternalEvent;
import org.killbill.billing.events.UserTagDefinitionDeletionInternalEvent;
import org.killbill.billing.events.UserTagDeletionInternalEvent;
import org.killbill.billing.util.UtilTestSuiteNoDB;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.DefaultTagDefinition;
import org.killbill.billing.util.tag.TagDefinition;
import org.killbill.billing.util.tag.api.user.DefaultControlTagCreationEvent;
import org.killbill.billing.util.tag.api.user.DefaultControlTagDefinitionCreationEvent;
import org.killbill.billing.util.tag.api.user.DefaultControlTagDefinitionDeletionEvent;
import org.killbill.billing.util.tag.api.user.DefaultControlTagDeletionEvent;
import org.killbill.billing.util.tag.api.user.DefaultUserTagCreationEvent;
import org.killbill.billing.util.tag.api.user.DefaultUserTagDefinitionCreationEvent;
import org.killbill.billing.util.tag.api.user.DefaultUserTagDefinitionDeletionEvent;
import org.killbill.billing.util.tag.api.user.DefaultUserTagDeletionEvent;
import org.killbill.billing.util.tag.api.user.TagEventBuilder;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTagEventBuilder
extends UtilTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testNewUserTagDefinitionCreationEvent() throws Exception {
        UUID tagDefinitionId = UUID.randomUUID();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = false;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(false));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        UserTagDefinitionCreationInternalEvent event = tagEventBuilder.newUserTagDefinitionCreationEvent(tagDefinitionId, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof UserTagDefinitionCreationInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultUserTagDefinitionCreationEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultUserTagDefinitionCreationEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagDefinitionEvent(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagDefinitionInternalEvent)event);
    }

    @Test(groups={"fast"})
    public void testNewUserTagDefinitionDeletionEvent() throws Exception {
        UUID tagDefinitionId = UUID.randomUUID();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = false;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(false));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        UserTagDefinitionDeletionInternalEvent event = tagEventBuilder.newUserTagDefinitionDeletionEvent(tagDefinitionId, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof UserTagDefinitionDeletionInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultUserTagDefinitionDeletionEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultUserTagDefinitionDeletionEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagDefinitionEvent(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagDefinitionInternalEvent)event);
    }

    @Test(groups={"fast"})
    public void testNewControlTagDefinitionCreationEvent() throws Exception {
        UUID tagDefinitionId = ControlTagType.AUTO_PAY_OFF.getId();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = true;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(true));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        ControlTagDefinitionCreationInternalEvent event = tagEventBuilder.newControlTagDefinitionCreationEvent(tagDefinitionId, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof ControlTagDefinitionCreationInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultControlTagDefinitionCreationEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultControlTagDefinitionCreationEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagDefinitionEvent(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagDefinitionInternalEvent)event);
    }

    @Test(groups={"fast"})
    public void testNewControlTagDefinitionDeletionEvent() throws Exception {
        UUID tagDefinitionId = ControlTagType.AUTO_PAY_OFF.getId();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = true;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(true));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        ControlTagDefinitionDeletionInternalEvent event = tagEventBuilder.newControlTagDefinitionDeletionEvent(tagDefinitionId, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof ControlTagDefinitionDeletionInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultControlTagDefinitionDeletionEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultControlTagDefinitionDeletionEvent(tagDefinitionId, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagDefinitionEvent(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagDefinitionInternalEvent)event);
    }

    @Test(groups={"fast"})
    public void testNewUserTagCreationEvent() throws Exception {
        UUID tagId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        UUID tagDefinitionId = UUID.randomUUID();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = false;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(false));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        UserTagCreationInternalEvent event = tagEventBuilder.newUserTagCreationEvent(tagId, objectId, objectType, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof UserTagCreationInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultUserTagCreationEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultUserTagCreationEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagEvent(tagId, objectId, objectType, tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagInternalEvent)event);
    }

    @Test(groups={"fast"})
    public void testNewUserTagDeletionEvent() throws Exception {
        UUID tagId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        UUID tagDefinitionId = UUID.randomUUID();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = false;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(false));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        UserTagDeletionInternalEvent event = tagEventBuilder.newUserTagDeletionEvent(tagId, objectId, objectType, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof UserTagDeletionInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultUserTagDeletionEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultUserTagDeletionEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagEvent(tagId, objectId, objectType, tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagInternalEvent)event);
    }

    @Test(groups={"fast"})
    public void testNewControlTagCreationEvent() throws Exception {
        UUID tagId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        UUID tagDefinitionId = ControlTagType.AUTO_PAY_OFF.getId();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = true;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(true));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        ControlTagCreationInternalEvent event = tagEventBuilder.newControlTagCreationEvent(tagId, objectId, objectType, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof ControlTagCreationInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultControlTagCreationEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultControlTagCreationEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagEvent(tagId, objectId, objectType, tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagInternalEvent)event);
    }

    @Test(groups={"fast"})
    public void testNewControlTagDeletionEvent() throws Exception {
        UUID tagId = UUID.randomUUID();
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.ACCOUNT_EMAIL;
        UUID tagDefinitionId = ControlTagType.AUTO_PAY_OFF.getId();
        String tagDefinitionName = UUID.randomUUID().toString();
        String tagDefinitionDescription = UUID.randomUUID().toString();
        boolean controlTag = true;
        DefaultTagDefinition tagDefinition = new DefaultTagDefinition(tagDefinitionId, tagDefinitionName, tagDefinitionDescription, Boolean.valueOf(true));
        UUID userToken = this.internalCallContext.getUserToken();
        TagEventBuilder tagEventBuilder = new TagEventBuilder();
        ControlTagDeletionInternalEvent event = tagEventBuilder.newControlTagDeletionEvent(tagId, objectId, objectType, new TagDefinitionModelDao((TagDefinition)tagDefinition), Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID());
        Assert.assertTrue((boolean)(event instanceof ControlTagDeletionInternalEvent));
        Assert.assertEquals((Object)event, (Object)new DefaultControlTagDeletionEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID()));
        Assert.assertTrue((boolean)event.equals(new DefaultControlTagDeletionEvent(tagId, objectId, objectType, (TagDefinition)tagDefinition, Long.valueOf(1L), Long.valueOf(2L), UUID.randomUUID())));
        this.verifyTagEvent(tagId, objectId, objectType, tagDefinitionId, tagDefinitionName, tagDefinitionDescription, (TagDefinition)tagDefinition, userToken, (TagInternalEvent)event);
    }

    private void verifyTagDefinitionEvent(UUID tagDefinitionId, String tagDefinitionName, String tagDefinitionDescription, TagDefinition tagDefinition, UUID userToken, TagDefinitionInternalEvent event) {
        Assert.assertEquals((Object)event.getTagDefinitionId(), (Object)tagDefinitionId);
        Assert.assertEquals((Object)event.getTagDefinition(), (Object)tagDefinition);
        Assert.assertEquals((Object)event.getTagDefinition().getId(), (Object)tagDefinitionId);
        Assert.assertEquals((String)event.getTagDefinition().getName(), (String)tagDefinitionName);
        Assert.assertEquals((String)event.getTagDefinition().getDescription(), (String)tagDefinitionDescription);
        Assert.assertEquals((Object)event, (Object)event);
        Assert.assertTrue((boolean)event.equals(event));
    }

    private void verifyTagEvent(UUID tagId, UUID objectId, ObjectType objectType, UUID tagDefinitionId, String tagDefinitionName, String tagDefinitionDescription, TagDefinition tagDefinition, UUID userToken, TagInternalEvent event) {
        Assert.assertEquals((Object)event.getTagId(), (Object)tagId);
        Assert.assertEquals((Object)event.getObjectId(), (Object)objectId);
        Assert.assertEquals((Object)event.getObjectType(), (Object)objectType);
        Assert.assertEquals((Object)event.getTagDefinition(), (Object)tagDefinition);
        Assert.assertEquals((Object)event.getTagDefinition().getId(), (Object)tagDefinitionId);
        Assert.assertEquals((String)event.getTagDefinition().getName(), (String)tagDefinitionName);
        Assert.assertEquals((String)event.getTagDefinition().getDescription(), (String)tagDefinitionDescription);
        Assert.assertEquals((Object)event, (Object)event);
        Assert.assertTrue((boolean)event.equals(event));
    }
}

