/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.MockEntityDaoBase;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.dao.TagDao;
import org.killbill.billing.util.tag.dao.TagModelDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockTagDao
extends MockEntityDaoBase<TagModelDao, Tag, TagApiException>
implements TagDao {
    private final Map<UUID, List<TagModelDao>> tagStore = new HashMap<UUID, List<TagModelDao>>();

    @Override
    public void create(TagModelDao tag, InternalCallContext context) throws TagApiException {
        if (this.tagStore.get(tag.getObjectId()) == null) {
            this.tagStore.put(tag.getObjectId(), new ArrayList());
        }
        this.tagStore.get(tag.getObjectId()).add(tag);
    }

    public void deleteTag(UUID objectId, ObjectType objectType, UUID tagDefinitionId, InternalCallContext context) {
        List<TagModelDao> tags = this.tagStore.get(objectId);
        if (tags != null) {
            Iterator<TagModelDao> tagIterator = tags.iterator();
            while (tagIterator.hasNext()) {
                TagModelDao tag = tagIterator.next();
                if (!tag.getTagDefinitionId().equals(tagDefinitionId)) continue;
                tagIterator.remove();
            }
        }
    }

    public Pagination<TagModelDao> searchTags(String searchKey, Long offset, Long limit, InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TagModelDao getById(UUID tagId, InternalTenantContext context) {
        throw new UnsupportedOperationException();
    }

    public List<TagModelDao> getTagsForObject(UUID objectId, final ObjectType objectType, boolean includedDeleted, InternalTenantContext internalTenantContext) {
        if (this.tagStore.get(objectId) == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)Collections2.filter((Collection)this.tagStore.get(objectId), (Predicate)new Predicate<TagModelDao>(){

            public boolean apply(TagModelDao input) {
                return objectType.equals((Object)input.getObjectType());
            }
        }));
    }

    public List<TagModelDao> getTagsForAccountType(ObjectType objectType, boolean includedDeleted, InternalTenantContext internalTenantContext) {
        throw new UnsupportedOperationException();
    }

    public List<TagModelDao> getTagsForAccount(boolean includedDeleted, InternalTenantContext internalTenantContext) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.tagStore.clear();
    }
}

