/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.DescriptiveTag;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.dao.SystemTags;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultTagDao
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testGetByIds() throws TagDefinitionApiException {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        List result = this.tagDefinitionDao.getByIds(uuids, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)result.size(), (int)0);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao defYo = this.tagDefinitionDao.create(UUID.randomUUID().toString().substring(0, 5), "defintion yo", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        uuids.add(defYo.getId());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao defBah = this.tagDefinitionDao.create(UUID.randomUUID().toString().substring(0, 5), "defintion bah", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        uuids.add(defBah.getId());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao defZoo = this.tagDefinitionDao.create(UUID.randomUUID().toString().substring(0, 5), "defintion zoo", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        uuids.add(defZoo.getId());
        result = this.tagDefinitionDao.getByIds(uuids, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)result.size(), (int)3);
        uuids.add(ControlTagType.AUTO_PAY_OFF.getId());
        result = this.tagDefinitionDao.getByIds(uuids, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)result.size(), (int)4);
        result = this.tagDefinitionDao.getTagDefinitions(true, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)result.size(), (int)(3 + SystemTags.get((boolean)true).size()));
    }

    @Test(groups={"slow"})
    public void testGetById() throws TagDefinitionApiException {
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao defYo = this.tagDefinitionDao.create(UUID.randomUUID().toString().substring(0, 5), "defintion yo", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        TagDefinitionModelDao resDefYo = (TagDefinitionModelDao)this.tagDefinitionDao.getById(defYo.getId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)defYo, (Object)resDefYo);
        try {
            this.tagDefinitionDao.create(ControlTagType.AUTO_INVOICING_OFF.name(), ControlTagType.AUTO_INVOICING_OFF.name(), (InternalCallContext)this.internalCallContext);
            Assert.fail((String)"Should not be able to create a invoice tag");
        }
        catch (TagDefinitionApiException tagDefinitionApiException) {
            // empty catch block
        }
        TagDefinitionModelDao resdef_AUTO_INVOICING_OFF = (TagDefinitionModelDao)this.tagDefinitionDao.getById(ControlTagType.AUTO_INVOICING_OFF.getId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)resdef_AUTO_INVOICING_OFF.getId(), (Object)ControlTagType.AUTO_INVOICING_OFF.getId());
        Assert.assertEquals((String)resdef_AUTO_INVOICING_OFF.getName(), (String)ControlTagType.AUTO_INVOICING_OFF.name());
        Assert.assertEquals((String)resdef_AUTO_INVOICING_OFF.getDescription(), (String)ControlTagType.AUTO_INVOICING_OFF.getDescription());
    }

    @Test(groups={"slow"})
    public void testGetByName() throws TagDefinitionApiException {
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao defYo = this.tagDefinitionDao.create(UUID.randomUUID().toString().substring(0, 5), "defintion yo", (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        TagDefinitionModelDao resDefYo = this.tagDefinitionDao.getByName(defYo.getName(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)defYo, (Object)resDefYo);
        try {
            this.tagDefinitionDao.create(ControlTagType.AUTO_PAY_OFF.name(), ControlTagType.AUTO_INVOICING_OFF.name(), (InternalCallContext)this.internalCallContext);
            Assert.fail((String)"Should not be able to create a invoice tag");
        }
        catch (TagDefinitionApiException tagDefinitionApiException) {
            // empty catch block
        }
        TagDefinitionModelDao resdef_AUTO_PAY_OFF = this.tagDefinitionDao.getByName(ControlTagType.AUTO_PAY_OFF.name(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)resdef_AUTO_PAY_OFF.getId(), (Object)ControlTagType.AUTO_PAY_OFF.getId());
        Assert.assertEquals((String)resdef_AUTO_PAY_OFF.getName(), (String)ControlTagType.AUTO_PAY_OFF.name());
        Assert.assertEquals((String)resdef_AUTO_PAY_OFF.getDescription(), (String)ControlTagType.AUTO_PAY_OFF.getDescription());
    }

    @Test(groups={"slow"})
    public void testCatchEventsOnCreateAndDelete() throws Exception {
        String definitionName = UUID.randomUUID().toString().substring(0, 5);
        String description = UUID.randomUUID().toString().substring(0, 5);
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.INVOICE_ITEM;
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao createdTagDefinition = this.tagDefinitionDao.create(definitionName, description, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((String)createdTagDefinition.getName(), (String)definitionName);
        Assert.assertEquals((String)createdTagDefinition.getDescription(), (String)description);
        this.assertListenerStatus();
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        DescriptiveTag tag = new DescriptiveTag(createdTagDefinition.getId(), objectType, objectId, this.internalCallContext.getCreatedDate());
        this.tagDao.create(new TagModelDao((Tag)tag), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        List foundTags = this.tagDao.getTagsForObject(objectId, objectType, false, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)foundTags.size(), (int)1);
        Assert.assertEquals((Object)((TagModelDao)foundTags.get(0)).getTagDefinitionId(), (Object)createdTagDefinition.getId());
        List foundTagsForAccount = this.tagDao.getTagsForAccount(false, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)foundTagsForAccount.size(), (int)1);
        Assert.assertEquals((Object)((TagModelDao)foundTagsForAccount.get(0)).getTagDefinitionId(), (Object)createdTagDefinition.getId());
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        this.tagDao.deleteTag(objectId, objectType, createdTagDefinition.getId(), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        Assert.assertEquals((int)this.tagDao.getTagsForObject(objectId, objectType, false, (InternalTenantContext)this.internalCallContext).size(), (int)0);
        Assert.assertEquals((int)this.tagDao.getTagsForAccount(false, (InternalTenantContext)this.internalCallContext).size(), (int)0);
        Assert.assertEquals((int)this.tagDao.getTagsForObject(objectId, objectType, true, (InternalTenantContext)this.internalCallContext).size(), (int)1);
        Assert.assertEquals((int)this.tagDao.getTagsForAccount(true, (InternalTenantContext)this.internalCallContext).size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testInsertMultipleTags() throws TagApiException {
        UUID objectId = UUID.randomUUID();
        ObjectType objectType = ObjectType.INVOICE_ITEM;
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG);
        DescriptiveTag tag = new DescriptiveTag(ControlTagType.AUTO_INVOICING_OFF.getId(), objectType, objectId, this.internalCallContext.getCreatedDate());
        this.tagDao.create(new TagModelDao((Tag)tag), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        try {
            DescriptiveTag tag2 = new DescriptiveTag(ControlTagType.AUTO_INVOICING_OFF.getId(), objectType, objectId, this.internalCallContext.getCreatedDate());
            this.tagDao.create(new TagModelDao((Tag)tag2), (InternalCallContext)this.internalCallContext);
            Assert.fail((String)"Should not be able to create twice the same tag");
            this.assertListenerStatus();
        }
        catch (TagApiException e) {
            Assert.assertEquals((int)ErrorCode.TAG_ALREADY_EXISTS.getCode(), (int)e.getCode());
        }
    }
}

