/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag.dao;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.api.TestApiListener;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.events.TagDefinitionInternalEvent;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultTagDefinitionDao
extends UtilTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testCatchEventsOnCreateAndDelete() throws Exception {
        String definitionName = UUID.randomUUID().toString().substring(0, 5);
        String description = UUID.randomUUID().toString().substring(0, 5);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        TagDefinitionModelDao createdTagDefinition = this.tagDefinitionDao.create(definitionName, description, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((String)createdTagDefinition.getName(), (String)definitionName);
        Assert.assertEquals((String)createdTagDefinition.getDescription(), (String)description);
        this.assertListenerStatus();
        TagDefinitionModelDao foundTagDefinition = this.tagDefinitionDao.getByName(definitionName, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)foundTagDefinition, (Object)createdTagDefinition);
        this.eventsListener.pushExpectedEvent(TestApiListener.NextEvent.TAG_DEFINITION);
        this.tagDefinitionDao.deleteById(foundTagDefinition.getId(), (InternalCallContext)this.internalCallContext);
        this.assertListenerStatus();
        Assert.assertNull((Object)this.tagDefinitionDao.getByName(definitionName, (InternalTenantContext)this.internalCallContext));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EventsListener {
        private final List<BusInternalEvent> events = new ArrayList<BusInternalEvent>();
        private final List<TagDefinitionInternalEvent> tagDefinitionEvents = new ArrayList<TagDefinitionInternalEvent>();

        private EventsListener() {
        }

        @Subscribe
        public synchronized void processEvent(BusInternalEvent event) {
            this.events.add(event);
        }

        @Subscribe
        public synchronized void processTagDefinitionEvent(TagDefinitionInternalEvent event) {
            this.tagDefinitionEvents.add(event);
        }

        public List<BusInternalEvent> getEvents() {
            return this.events;
        }

        public List<TagDefinitionInternalEvent> getTagDefinitionEvents() {
            return this.tagDefinitionEvents;
        }
    }
}

