/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.validation;

import java.util.Collection;
import org.joda.time.DateTime;
import org.killbill.billing.util.UtilTestSuiteWithEmbeddedDB;
import org.killbill.billing.util.validation.DefaultColumnInfo;
import org.killbill.billing.util.validation.ValidationConfiguration;
import org.killbill.billing.util.validation.ValidationManager;
import org.killbill.billing.util.validation.dao.DatabaseSchemaDao;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestValidationManager
extends UtilTestSuiteWithEmbeddedDB {
    private static final String TABLE_NAME = "validation_test";
    private ValidationManager vm;

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        DatabaseSchemaDao dao = new DatabaseSchemaDao(this.dbi);
        this.vm = new ValidationManager(dao);
        this.vm.loadSchemaInformation(this.helper.getDatabaseName());
    }

    @Test(groups={"slow"})
    public void testRetrievingColumnInfo() {
        Collection columnInfoList = this.vm.getTableInfo(TABLE_NAME);
        Assert.assertEquals((int)columnInfoList.size(), (int)4);
        Assert.assertNotNull((Object)this.vm.getColumnInfo(TABLE_NAME, "column1"));
        Assert.assertNull((Object)this.vm.getColumnInfo(TABLE_NAME, "bogus"));
        DefaultColumnInfo numericColumnInfo = this.vm.getColumnInfo(TABLE_NAME, "column3");
        Assert.assertNotNull((Object)numericColumnInfo);
        Assert.assertEquals((Object)numericColumnInfo.getScale(), (Object)4L);
        Assert.assertEquals((Object)numericColumnInfo.getPrecision(), (Object)10L);
    }

    @Test(groups={"slow"})
    public void testSimpleConfiguration() {
        String STRING_FIELD_2 = "column2";
        String STRING_FIELD_2_PROPERTY = "stringField2";
        SimpleTestClass testObject = new SimpleTestClass(null, null, 7.9, new DateTime());
        this.vm.setConfiguration(testObject.getClass(), "stringField2", this.vm.getColumnInfo(TABLE_NAME, "column2"));
        Assert.assertTrue((boolean)this.vm.hasConfiguration(testObject.getClass()));
        Assert.assertFalse((boolean)this.vm.hasConfiguration(ValidationManager.class));
        ValidationConfiguration configuration = this.vm.getConfiguration(SimpleTestClass.class);
        Assert.assertNotNull((Object)configuration);
        Assert.assertTrue((boolean)configuration.hasMapping("stringField2"));
        Assert.assertFalse((boolean)this.vm.validate((Object)testObject));
        testObject.setStringField2("a");
        Assert.assertFalse((boolean)this.vm.validate((Object)testObject));
        testObject.setStringField2("abc");
        Assert.assertFalse((boolean)this.vm.validate((Object)testObject));
        testObject.setStringField2("ab");
        Assert.assertTrue((boolean)this.vm.validate((Object)testObject));
        String STRING_FIELD_1 = "column1";
        String STRING_FIELD_1_PROPERTY = "stringField1";
        this.vm.setConfiguration(testObject.getClass(), "stringField1", this.vm.getColumnInfo(TABLE_NAME, "column1"));
        Assert.assertTrue((boolean)this.vm.validate((Object)testObject));
        testObject.setStringField1("This is a long string that exceeds the length limit for column 1.");
        Assert.assertFalse((boolean)this.vm.validate((Object)testObject));
        testObject.setStringField1("This is a short string.");
        Assert.assertTrue((boolean)this.vm.validate((Object)testObject));
        String NUMERIC_FIELD = "column3";
        String NUMERIC_FIELD_PROPERTY = "numericField1";
        this.vm.setConfiguration(testObject.getClass(), "numericField1", this.vm.getColumnInfo(TABLE_NAME, "column3"));
        Assert.assertTrue((boolean)this.vm.validate((Object)testObject));
        testObject.setNumericField1(0.123456);
        Assert.assertFalse((boolean)this.vm.validate((Object)testObject));
        testObject.setNumericField1(1.2345678901234E13);
        Assert.assertFalse((boolean)this.vm.validate((Object)testObject));
        testObject.setNumericField1(1.23456789E9);
        Assert.assertTrue((boolean)this.vm.validate((Object)testObject));
        testObject.setNumericField1(123456.7891);
        Assert.assertTrue((boolean)this.vm.validate((Object)testObject));
        testObject.setNumericField1(1.234567891E7);
        Assert.assertTrue((boolean)this.vm.validate((Object)testObject));
    }

    private class SimpleTestClass {
        private String stringField1;
        private String stringField2;
        private double numericField1;
        private DateTime dateTimeField1;

        public SimpleTestClass(String stringField1, String stringField2, double numericField1, DateTime dateTimeField1) {
            this.stringField1 = stringField1;
            this.stringField2 = stringField2;
            this.numericField1 = numericField1;
            this.dateTimeField1 = dateTimeField1;
        }

        public String getStringField1() {
            return this.stringField1;
        }

        public void setStringField1(String stringField1) {
            this.stringField1 = stringField1;
        }

        public String getStringField2() {
            return this.stringField2;
        }

        public void setStringField2(String stringField2) {
            this.stringField2 = stringField2;
        }

        public double getNumericField1() {
            return this.numericField1;
        }

        public void setNumericField1(double numericField1) {
            this.numericField1 = numericField1;
        }

        public DateTime getDateTimeField1() {
            return this.dateTimeField1;
        }

        public void setDateTimeField1(DateTime dateTimeField1) {
            this.dateTimeField1 = dateTimeField1;
        }
    }
}

