/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.account;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;

public abstract class AccountDateTimeUtils {
    public static DateTimeZone getFixedOffsetTimeZone(TimeZoneAwareEntity account) {
        return AccountDateTimeUtils.getFixedOffsetTimeZone(account.getTimeZone(), account);
    }

    public static DateTimeZone getFixedOffsetTimeZone(Account account) {
        return AccountDateTimeUtils.getFixedOffsetTimeZone(account.getTimeZone(), (Entity)account);
    }

    public static DateTimeZone getFixedOffsetTimeZone(DateTimeZone referenceDateTimeZone, Entity account) {
        boolean shouldUseDST;
        DateTime referenceDateTime = AccountDateTimeUtils.getReferenceDateTime(account);
        boolean bl = shouldUseDST = !referenceDateTimeZone.isStandardOffset(referenceDateTime.getMillis());
        if (shouldUseDST) {
            return DateTimeZone.forOffsetMillis((int)referenceDateTimeZone.getOffset(referenceDateTime.getMillis()));
        }
        return DateTimeZone.forOffsetMillis((int)referenceDateTimeZone.getStandardOffset(referenceDateTime.getMillis()));
    }

    public static DateTime getReferenceDateTime(Entity account) {
        return account.getCreatedDate();
    }
}

