/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.audit.AccountAuditLogs;
import org.killbill.billing.util.audit.AccountAuditLogsForObjectType;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.DefaultAccountAuditLogsForObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountAuditLogs
implements AccountAuditLogs {
    private final UUID accountId;
    private final AuditLevel auditLevel;
    private final Collection<AuditLog> accountAuditLogs;
    private final Map<ObjectType, DefaultAccountAuditLogsForObjectType> auditLogsCache = new HashMap<ObjectType, DefaultAccountAuditLogsForObjectType>();

    public DefaultAccountAuditLogs(UUID accountId) {
        this(accountId, AuditLevel.NONE, (Iterator<AuditLog>)ImmutableSet.of().iterator());
    }

    public DefaultAccountAuditLogs(UUID accountId, AuditLevel auditLevel, Iterator<AuditLog> accountAuditLogsOrderedByTableName) {
        this.accountId = accountId;
        this.auditLevel = auditLevel;
        this.accountAuditLogs = ImmutableList.copyOf(accountAuditLogsOrderedByTableName);
    }

    public void close() {
    }

    public List<AuditLog> getAuditLogsForAccount() {
        return this.getAuditLogs(ObjectType.ACCOUNT).getAuditLogs(this.accountId);
    }

    public List<AuditLog> getAuditLogsForBundle(UUID bundleId) {
        return this.getAuditLogs(ObjectType.BUNDLE).getAuditLogs(bundleId);
    }

    public List<AuditLog> getAuditLogsForSubscription(UUID subscriptionId) {
        return this.getAuditLogs(ObjectType.SUBSCRIPTION).getAuditLogs(subscriptionId);
    }

    public List<AuditLog> getAuditLogsForSubscriptionEvent(UUID subscriptionEventId) {
        return this.getAuditLogs(ObjectType.SUBSCRIPTION_EVENT).getAuditLogs(subscriptionEventId);
    }

    public List<AuditLog> getAuditLogsForInvoice(UUID invoiceId) {
        return this.getAuditLogs(ObjectType.INVOICE).getAuditLogs(invoiceId);
    }

    public List<AuditLog> getAuditLogsForInvoiceItem(UUID invoiceItemId) {
        return this.getAuditLogs(ObjectType.INVOICE_ITEM).getAuditLogs(invoiceItemId);
    }

    public List<AuditLog> getAuditLogsForPayment(UUID paymentId) {
        return this.getAuditLogs(ObjectType.PAYMENT).getAuditLogs(paymentId);
    }

    public List<AuditLog> getAuditLogsForPaymentTransaction(UUID paymentTransactionId) {
        return this.getAuditLogs(ObjectType.TRANSACTION).getAuditLogs(paymentTransactionId);
    }

    public List<AuditLog> getAuditLogsForPaymentAttempt(UUID paymentAttemptId) {
        return this.getAuditLogs(ObjectType.PAYMENT_ATTEMPT).getAuditLogs(paymentAttemptId);
    }

    public List<AuditLog> getAuditLogsForPaymentMethod(UUID paymentMethodId) {
        return this.getAuditLogs(ObjectType.PAYMENT_METHOD).getAuditLogs(paymentMethodId);
    }

    public List<AuditLog> getAuditLogsForBlockingState(UUID blockingStateId) {
        return this.getAuditLogs(ObjectType.BLOCKING_STATES).getAuditLogs(blockingStateId);
    }

    public List<AuditLog> getAuditLogsForInvoicePayment(UUID invoicePaymentId) {
        return this.getAuditLogs(ObjectType.INVOICE_PAYMENT).getAuditLogs(invoicePaymentId);
    }

    public List<AuditLog> getAuditLogsForTag(UUID tagId) {
        return this.getAuditLogs(ObjectType.TAG).getAuditLogs(tagId);
    }

    public List<AuditLog> getAuditLogsForCustomField(UUID customFieldId) {
        return this.getAuditLogs(ObjectType.CUSTOM_FIELD).getAuditLogs(customFieldId);
    }

    public AccountAuditLogsForObjectType getAuditLogs(ObjectType objectType) {
        if (this.auditLogsCache.get(objectType) == null) {
            this.auditLogsCache.put(objectType, new DefaultAccountAuditLogsForObjectType(this.auditLevel, (Iterator<AuditLog>)((Object)new ObjectTypeFilter(objectType, this.accountAuditLogs.iterator()))));
        }
        return this.auditLogsCache.get(objectType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ObjectTypeFilter
    extends AbstractIterator<AuditLog> {
        private boolean hasSeenObjectType = false;
        private final ObjectType objectType;
        private final Iterator<AuditLog> accountAuditLogs;
        private final Predicate<AuditLog> predicate = new Predicate<AuditLog>(){

            public boolean apply(AuditLog auditLog) {
                return ObjectTypeFilter.this.objectType.equals((Object)auditLog.getAuditedObjectType());
            }
        };

        private ObjectTypeFilter(ObjectType objectType, Iterator<AuditLog> accountAuditLogs) {
            this.objectType = objectType;
            this.accountAuditLogs = accountAuditLogs;
        }

        protected AuditLog computeNext() {
            while (this.accountAuditLogs.hasNext()) {
                AuditLog element = this.accountAuditLogs.next();
                if (this.predicate.apply((Object)element)) {
                    this.hasSeenObjectType = true;
                    return element;
                }
                if (!this.hasSeenObjectType) continue;
                return (AuditLog)this.endOfData();
            }
            return (AuditLog)this.endOfData();
        }
    }
}

