/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.audit.AccountAuditLogsForObjectType;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.customfield.ShouldntHappenException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountAuditLogsForObjectType
implements AccountAuditLogsForObjectType {
    private final Map<UUID, List<AuditLog>> auditLogsCache;
    private final AuditLevel auditLevel;
    private final Iterator<AuditLog> allAuditLogsForObjectType;

    public DefaultAccountAuditLogsForObjectType(AuditLevel auditLevel) {
        this(auditLevel, (Iterator<AuditLog>)ImmutableSet.of().iterator());
    }

    public DefaultAccountAuditLogsForObjectType(AuditLevel auditLevel, Iterator<AuditLog> allAuditLogsForObjectType) {
        this.auditLevel = auditLevel;
        this.auditLogsCache = new HashMap<UUID, List<AuditLog>>();
        this.allAuditLogsForObjectType = allAuditLogsForObjectType;
    }

    void initializeIfNeeded(UUID objectId) {
        if (this.auditLogsCache.get(objectId) == null) {
            this.auditLogsCache.put(objectId, new LinkedList());
        }
    }

    public void close() {
        while (this.allAuditLogsForObjectType.hasNext()) {
            this.allAuditLogsForObjectType.next();
        }
    }

    public List<AuditLog> getAuditLogs(final UUID objectId) {
        switch (this.auditLevel) {
            case FULL: {
                this.cacheAllAuditLogs();
                this.initializeIfNeeded(objectId);
                return this.auditLogsCache.get(objectId);
            }
            case MINIMAL: {
                AuditLog candidate;
                if (this.auditLogsCache.get(objectId) == null && (candidate = (AuditLog)Iterators.tryFind(this.allAuditLogsForObjectType, (Predicate)new Predicate<AuditLog>(){

                    public boolean apply(AuditLog auditLog) {
                        DefaultAccountAuditLogsForObjectType.this.cacheAuditLog(auditLog);
                        return objectId.equals(auditLog.getAuditedEntityId()) && ChangeType.INSERT.equals((Object)auditLog.getChangeType());
                    }
                }).orNull()) == null) {
                    this.initializeIfNeeded(objectId);
                }
                return this.auditLogsCache.get(objectId);
            }
            case NONE: {
                this.close();
                return ImmutableList.of();
            }
        }
        throw new ShouldntHappenException("AuditLevel " + this.auditLevel + " unsupported");
    }

    private void cacheAllAuditLogs() {
        while (this.allAuditLogsForObjectType.hasNext()) {
            AuditLog auditLog = this.allAuditLogsForObjectType.next();
            this.cacheAuditLog(auditLog);
        }
    }

    private void cacheAuditLog(AuditLog auditLog) {
        this.initializeIfNeeded(auditLog.getAuditedEntityId());
        this.auditLogsCache.get(auditLog.getAuditedEntityId()).add(auditLog);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultAccountAuditLogsForObjectType{");
        sb.append("auditLogsCache=").append(this.auditLogsCache);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAccountAuditLogsForObjectType that = (DefaultAccountAuditLogsForObjectType)o;
        return this.auditLogsCache.equals(that.auditLogsCache);
    }

    public int hashCode() {
        return this.auditLogsCache.hashCode();
    }
}

