/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.audit.dao;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.DefaultAccountAuditLogs;
import org.killbill.billing.util.audit.DefaultAccountAuditLogsForObjectType;
import org.killbill.billing.util.audit.DefaultAuditLog;
import org.killbill.billing.util.audit.dao.AuditDao;
import org.killbill.billing.util.audit.dao.AuditLogModelDao;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.dao.NonEntitySqlDao;
import org.killbill.billing.util.dao.RecordIdIdMappings;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuditDao
implements AuditDao {
    private final NonEntitySqlDao nonEntitySqlDao;
    private final EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao;

    @Inject
    public DefaultAuditDao(IDBI dbi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        this.nonEntitySqlDao = (NonEntitySqlDao)dbi.onDemand(NonEntitySqlDao.class);
        this.transactionalSqlDao = new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, cacheControllerDispatcher, nonEntityDao, internalCallContextFactory);
    }

    @Override
    public DefaultAccountAuditLogs getAuditLogsForAccountRecordId(AuditLevel auditLevel, InternalTenantContext context) {
        UUID accountId = this.nonEntitySqlDao.getIdFromObject(context.getAccountRecordId(), TableName.ACCOUNT.getTableName());
        EntitySqlDao auditSqlDao = this.transactionalSqlDao.onDemandForStreamingResults(EntitySqlDao.class);
        Iterator<AuditLogModelDao> auditLogsForAccountRecordId = auditSqlDao.getAuditLogsForAccountRecordId(context);
        Iterator<AuditLog> allAuditLogs = this.buildAuditLogsFromModelDao(auditLogsForAccountRecordId, context);
        return new DefaultAccountAuditLogs(accountId, auditLevel, allAuditLogs);
    }

    @Override
    public DefaultAccountAuditLogsForObjectType getAuditLogsForAccountRecordId(TableName tableName, AuditLevel auditLevel, InternalTenantContext context) {
        String actualTableName = tableName.hasHistoryTable() ? tableName.getHistoryTableName().name() : tableName.getTableName();
        EntitySqlDao auditSqlDao = this.transactionalSqlDao.onDemandForStreamingResults(EntitySqlDao.class);
        Iterator<AuditLogModelDao> auditLogsForTableNameAndAccountRecordId = auditSqlDao.getAuditLogsForTableNameAndAccountRecordId(actualTableName, context);
        Iterator<AuditLog> allAuditLogs = this.buildAuditLogsFromModelDao(auditLogsForTableNameAndAccountRecordId, context);
        return new DefaultAccountAuditLogsForObjectType(auditLevel, allAuditLogs);
    }

    private Iterator<AuditLog> buildAuditLogsFromModelDao(Iterator<AuditLogModelDao> auditLogsForAccountRecordId, final InternalTenantContext tenantContext) {
        final HashMap recordIdIdsCache = new HashMap();
        final HashMap historyRecordIdIdsCache = new HashMap();
        return Iterators.transform(auditLogsForAccountRecordId, (Function)new Function<AuditLogModelDao, AuditLog>(){

            public AuditLog apply(AuditLogModelDao input) {
                UUID auditedEntityId;
                ObjectType objectType;
                TableName originalTableNameForHistoryTableName = this.findTableNameForHistoryTableName(input.getTableName());
                if (originalTableNameForHistoryTableName != null) {
                    objectType = originalTableNameForHistoryTableName.getObjectType();
                    if (historyRecordIdIdsCache.get((Object)originalTableNameForHistoryTableName) == null) {
                        if (TableName.ACCOUNT.equals((Object)originalTableNameForHistoryTableName)) {
                            Iterable<RecordIdIdMappings> mappings = DefaultAuditDao.this.nonEntitySqlDao.getHistoryRecordIdIdMappingsForAccountsTable(originalTableNameForHistoryTableName.getTableName(), input.getTableName().getTableName(), tenantContext);
                            historyRecordIdIdsCache.put(originalTableNameForHistoryTableName, RecordIdIdMappings.toMap(mappings));
                        } else if (TableName.TAG_DEFINITIONS.equals((Object)originalTableNameForHistoryTableName)) {
                            Iterable<RecordIdIdMappings> mappings = DefaultAuditDao.this.nonEntitySqlDao.getHistoryRecordIdIdMappingsForTablesWithoutAccountRecordId(originalTableNameForHistoryTableName.getTableName(), input.getTableName().getTableName(), tenantContext);
                            historyRecordIdIdsCache.put(originalTableNameForHistoryTableName, RecordIdIdMappings.toMap(mappings));
                        } else {
                            Iterable<RecordIdIdMappings> mappings = DefaultAuditDao.this.nonEntitySqlDao.getHistoryRecordIdIdMappings(originalTableNameForHistoryTableName.getTableName(), input.getTableName().getTableName(), tenantContext);
                            historyRecordIdIdsCache.put(originalTableNameForHistoryTableName, RecordIdIdMappings.toMap(mappings));
                        }
                    }
                    auditedEntityId = (UUID)((Map)historyRecordIdIdsCache.get((Object)originalTableNameForHistoryTableName)).get(input.getTargetRecordId());
                } else {
                    objectType = input.getTableName().getObjectType();
                    if (recordIdIdsCache.get((Object)input.getTableName()) == null) {
                        Iterable<RecordIdIdMappings> mappings = DefaultAuditDao.this.nonEntitySqlDao.getRecordIdIdMappings(input.getTableName().getTableName(), tenantContext);
                        recordIdIdsCache.put(input.getTableName(), RecordIdIdMappings.toMap(mappings));
                    }
                    auditedEntityId = (UUID)((Map)recordIdIdsCache.get((Object)input.getTableName())).get(input.getTargetRecordId());
                }
                return new DefaultAuditLog(input, objectType, auditedEntityId);
            }

            private TableName findTableNameForHistoryTableName(TableName historyTableName) {
                for (TableName tableName : TableName.values()) {
                    if (!historyTableName.equals((Object)tableName.getHistoryTableName())) continue;
                    return tableName;
                }
                return null;
            }
        });
    }

    @Override
    public List<AuditLog> getAuditLogsForId(TableName tableName, UUID objectId, AuditLevel auditLevel, InternalTenantContext context) {
        if (tableName.hasHistoryTable()) {
            return this.doGetAuditLogsViaHistoryForId(tableName, objectId, auditLevel, context);
        }
        return this.doGetAuditLogsForId(tableName, objectId, auditLevel, context);
    }

    private List<AuditLog> doGetAuditLogsForId(TableName tableName, UUID objectId, AuditLevel auditLevel, InternalTenantContext context) {
        Long recordId = this.nonEntitySqlDao.getRecordIdFromObject(objectId.toString(), tableName.getTableName());
        if (recordId == null) {
            return ImmutableList.of();
        }
        return this.getAuditLogsForRecordId(tableName, objectId, recordId, auditLevel, context);
    }

    private List<AuditLog> doGetAuditLogsViaHistoryForId(final TableName tableName, final UUID objectId, AuditLevel auditLevel, final InternalTenantContext context) {
        final TableName historyTableName = tableName.getHistoryTableName();
        if (historyTableName == null) {
            throw new IllegalStateException("History table shouldn't be null for " + (Object)((Object)tableName));
        }
        final Long targetRecordId = this.nonEntitySqlDao.getRecordIdFromObject(objectId.toString(), tableName.getTableName());
        List<AuditLog> allAuditLogs = this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<List<AuditLog>>(){

            @Override
            public List<AuditLog> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                List<AuditLogModelDao> auditLogsViaHistoryForTargetRecordId = entitySqlDaoWrapperFactory.become(EntitySqlDao.class).getAuditLogsViaHistoryForTargetRecordId(historyTableName.name(), historyTableName.getTableName().toLowerCase(), targetRecordId, context);
                return DefaultAuditDao.this.buildAuditLogsFromModelDao(auditLogsViaHistoryForTargetRecordId, tableName.getObjectType(), objectId);
            }
        });
        return this.filterAuditLogs(auditLevel, allAuditLogs);
    }

    private List<AuditLog> getAuditLogsForRecordId(final TableName tableName, final UUID auditedEntityId, final Long targetRecordId, AuditLevel auditLevel, final InternalTenantContext context) {
        List<AuditLog> allAuditLogs = this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<List<AuditLog>>(){

            @Override
            public List<AuditLog> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                List<AuditLogModelDao> auditLogsForTargetRecordId = entitySqlDaoWrapperFactory.become(EntitySqlDao.class).getAuditLogsForTargetRecordId(tableName.name(), targetRecordId, context);
                return DefaultAuditDao.this.buildAuditLogsFromModelDao(auditLogsForTargetRecordId, tableName.getObjectType(), auditedEntityId);
            }
        });
        return this.filterAuditLogs(auditLevel, allAuditLogs);
    }

    private List<AuditLog> buildAuditLogsFromModelDao(List<AuditLogModelDao> auditLogsForAccountRecordId, final ObjectType objectType, final UUID auditedEntityId) {
        return Lists.transform(auditLogsForAccountRecordId, (Function)new Function<AuditLogModelDao, AuditLog>(){

            public AuditLog apply(AuditLogModelDao input) {
                return new DefaultAuditLog(input, objectType, auditedEntityId);
            }
        });
    }

    private List<AuditLog> filterAuditLogs(AuditLevel auditLevel, List<AuditLog> auditLogs) {
        if (AuditLevel.FULL.equals((Object)auditLevel)) {
            return auditLogs;
        }
        if (AuditLevel.MINIMAL.equals((Object)auditLevel) && !auditLogs.isEmpty()) {
            if (ChangeType.INSERT.equals((Object)auditLogs.get(0).getChangeType())) {
                return ImmutableList.of((Object)auditLogs.get(0));
            }
            return ImmutableList.of();
        }
        if (AuditLevel.NONE.equals((Object)auditLevel)) {
            return ImmutableList.of();
        }
        return auditLogs;
    }
}

