/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.broadcast.dao;

import java.util.List;
import javax.inject.Inject;
import org.killbill.billing.util.broadcast.dao.BroadcastDao;
import org.killbill.billing.util.broadcast.dao.BroadcastModelDao;
import org.killbill.billing.util.broadcast.dao.BroadcastSqlDao;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBroadcastDao
implements BroadcastDao {
    private final IDBI dbi;
    private final Clock clock;

    @Inject
    public DefaultBroadcastDao(IDBI dbi, Clock clock) {
        this.dbi = dbi;
        this.clock = clock;
    }

    @Override
    public void create(final BroadcastModelDao broadcastModelDao) {
        this.dbi.inTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void inTransaction(Handle handle, TransactionStatus status) throws Exception {
                BroadcastSqlDao sqlDao = (BroadcastSqlDao)handle.attach(BroadcastSqlDao.class);
                sqlDao.create(broadcastModelDao);
                return null;
            }
        });
    }

    @Override
    public List<BroadcastModelDao> getLatestEntriesFrom(final Long recordId) {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<BroadcastModelDao>>(){

            public List<BroadcastModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                BroadcastSqlDao sqlDao = (BroadcastSqlDao)handle.attach(BroadcastSqlDao.class);
                return sqlDao.getLatestEntries(recordId);
            }
        });
    }

    @Override
    public BroadcastModelDao getLatestEntry() {
        return (BroadcastModelDao)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<BroadcastModelDao>(){

            public BroadcastModelDao inTransaction(Handle handle, TransactionStatus status) throws Exception {
                BroadcastSqlDao sqlDao = (BroadcastSqlDao)handle.attach(BroadcastSqlDao.class);
                return sqlDao.getLatestEntry();
            }
        });
    }
}

