/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.audit.dao.AuditLogModelDao;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.dao.AuditSqlDao;
import org.skife.jdbi.v2.IDBI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AuditLogViaHistoryCacheLoader
extends BaseCacheLoader<String, List<AuditLogModelDao>> {
    private final AuditSqlDao auditSqlDao;

    @Inject
    public AuditLogViaHistoryCacheLoader(IDBI dbi) {
        this.auditSqlDao = (AuditSqlDao)dbi.onDemand(AuditSqlDao.class);
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.AUDIT_LOG_VIA_HISTORY;
    }

    @Override
    public List<AuditLogModelDao> compute(String key, CacheLoaderArgument cacheLoaderArgument) {
        Object[] args = cacheLoaderArgument.getArgs();
        String tableName = (String)args[0];
        String historyTableName = (String)args[1];
        Long targetRecordId = (Long)args[2];
        InternalTenantContext internalTenantContext = (InternalTenantContext)args[3];
        return this.auditSqlDao.getAuditLogsViaHistoryForTargetRecordId(tableName, historyTableName, targetRecordId, internalTenantContext);
    }
}

