/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControllerDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(CacheControllerDispatcher.class);
    public static final String CACHE_KEY_SEPARATOR = "::";
    private final Map<Cachable.CacheType, CacheController<Object, Object>> caches;

    @Inject
    public CacheControllerDispatcher(Map<Cachable.CacheType, CacheController<Object, Object>> caches) {
        this.caches = caches;
    }

    public CacheControllerDispatcher() {
        this.caches = new HashMap<Cachable.CacheType, CacheController<Object, Object>>();
    }

    public <K, V> CacheController<K, V> getCacheController(Cachable.CacheType cacheType) {
        return CacheControllerDispatcher.cast(this.caches.get((Object)cacheType));
    }

    public void clearAll() {
        for (CacheController<Object, Object> cacheController : this.caches.values()) {
            cacheController.removeAll();
        }
    }

    private static <K, V> CacheController<K, V> cast(CacheController<?, ?> cache) {
        return cache;
    }
}

