/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class OverriddenPlanCacheLoader
extends BaseCacheLoader<String, Plan> {
    private final Logger log = LoggerFactory.getLogger(OverriddenPlanCacheLoader.class);

    @Inject
    public OverriddenPlanCacheLoader() {
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.OVERRIDDEN_PLAN;
    }

    @Override
    public Plan compute(String key, CacheLoaderArgument cacheLoaderArgument) {
        if (cacheLoaderArgument.getArgs() == null || cacheLoaderArgument.getArgs().length != 2) {
            throw new IllegalArgumentException("Invalid arguments for overridden plans");
        }
        if (!(cacheLoaderArgument.getArgs()[0] instanceof LoaderCallback)) {
            throw new IllegalArgumentException("Invalid arguments for overridden plans: missing loaderCallback from argument");
        }
        if (!(cacheLoaderArgument.getArgs()[1] instanceof StaticCatalog)) {
            throw new IllegalArgumentException("Invalid arguments for overridden plans: missing catalog from argument");
        }
        String planName = key;
        LoaderCallback callback = (LoaderCallback)cacheLoaderArgument.getArgs()[0];
        StaticCatalog catalog = (StaticCatalog)cacheLoaderArgument.getArgs()[1];
        InternalTenantContext internalTenantContext = cacheLoaderArgument.getInternalTenantContext();
        try {
            this.log.info("Loading overridden plan {} for tenant {}", (Object)planName, (Object)internalTenantContext.getTenantRecordId());
            return callback.loadPlan(planName, catalog, internalTenantContext);
        }
        catch (CatalogApiException e) {
            throw new IllegalStateException(String.format("Failed to load overridden plan for tenant %s : %s", planName, internalTenantContext.getTenantRecordId()), e);
        }
    }

    public static interface LoaderCallback {
        public Plan loadPlan(String var1, StaticCatalog var2, InternalTenantContext var3) throws CatalogApiException;
    }
}

