/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.cache.BaseIdCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.dao.NonEntityDao;
import org.skife.jdbi.v2.Handle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RecordIdCacheLoader
extends BaseIdCacheLoader<Long> {
    private final NonEntityDao nonEntityDao;

    @Inject
    public RecordIdCacheLoader(NonEntityDao nonEntityDao) {
        this.nonEntityDao = nonEntityDao;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.RECORD_ID;
    }

    @Override
    protected Long doRetrieveOperation(String rawKey, ObjectType objectType, Handle handle) {
        return this.nonEntityDao.retrieveRecordIdFromObjectInTransaction(UUID.fromString(rawKey), objectType, null, handle);
    }
}

