/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.tenant.api.Tenant;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TenantCacheLoader
extends BaseCacheLoader<String, Tenant> {
    private final TenantInternalApi tenantApi;

    @Inject
    public TenantCacheLoader(TenantInternalApi tenantApi) {
        this.tenantApi = tenantApi;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.TENANT;
    }

    @Override
    public Tenant compute(String key, CacheLoaderArgument cacheLoaderArgument) {
        try {
            return this.tenantApi.getTenantByApiKey(key);
        }
        catch (TenantApiException e) {
            throw new IllegalStateException("TenantCacheLoader cannot find value for key " + key);
        }
    }
}

