/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.config.tenant.PerTenantConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TenantConfigCacheLoader
extends BaseCacheLoader<Long, PerTenantConfig> {
    private final Logger log = LoggerFactory.getLogger(TenantConfigCacheLoader.class);
    private final TenantInternalApi tenantApi;

    @Inject
    public TenantConfigCacheLoader(TenantInternalApi tenantApi) {
        this.tenantApi = tenantApi;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.TENANT_CONFIG;
    }

    @Override
    public PerTenantConfig compute(Long key, CacheLoaderArgument cacheLoaderArgument) {
        Long tenantRecordId = key;
        InternalTenantContext internalTenantContext = new InternalTenantContext(tenantRecordId);
        if (cacheLoaderArgument.getArgs() == null || !(cacheLoaderArgument.getArgs()[0] instanceof LoaderCallback)) {
            throw new IllegalArgumentException("Missing LoaderCallback from the arguments ");
        }
        LoaderCallback loader = (LoaderCallback)cacheLoaderArgument.getArgs()[0];
        String jsonValue = this.tenantApi.getTenantConfig(internalTenantContext);
        try {
            return loader.loadConfig(jsonValue);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize per tenant config for tenant recordId = " + tenantRecordId, e);
        }
    }

    public static interface LoaderCallback {
        public PerTenantConfig loadConfig(String var1) throws IOException;
    }
}

