/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.cache;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.cache.BaseCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TenantOverdueConfigCacheLoader
extends BaseCacheLoader<Long, Object> {
    private static final Logger log = LoggerFactory.getLogger(TenantOverdueConfigCacheLoader.class);
    private final TenantInternalApi tenantApi;

    @Inject
    public TenantOverdueConfigCacheLoader(TenantInternalApi tenantApi) {
        this.tenantApi = tenantApi;
    }

    @Override
    public Cachable.CacheType getCacheType() {
        return Cachable.CacheType.TENANT_OVERDUE_CONFIG;
    }

    @Override
    public Object compute(Long key, CacheLoaderArgument cacheLoaderArgument) {
        Long tenantRecordId = key;
        InternalTenantContext internalTenantContext = new InternalTenantContext(tenantRecordId);
        if (cacheLoaderArgument.getArgs() == null || !(cacheLoaderArgument.getArgs()[0] instanceof LoaderCallback)) {
            throw new IllegalArgumentException("Missing LoaderCallback from the arguments");
        }
        LoaderCallback callback = (LoaderCallback)cacheLoaderArgument.getArgs()[0];
        String overdueXML = this.tenantApi.getTenantOverdueConfig(internalTenantContext);
        if (overdueXML == null) {
            return "__#VALEUR!__";
        }
        try {
            log.info("Loading overdue cache for tenant " + internalTenantContext.getTenantRecordId());
            return callback.loadOverdueConfig(overdueXML);
        }
        catch (OverdueApiException e) {
            throw new IllegalStateException(String.format("Failed to de-serialize overdue config for tenant %s : %s", internalTenantContext.getTenantRecordId(), e.getMessage()), e);
        }
    }

    public static interface LoaderCallback {
        public OverdueConfig loadOverdueConfig(String var1) throws OverdueApiException;
    }
}

