/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.callcontext;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.sqlobject.BindingAnnotation;

@BindingAnnotation(value=InternalTenantContextBinderFactory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface InternalTenantContextBinder {

    public static class InternalTenantContextBinderFactory
    implements BinderFactory {
        public Binder build(Annotation annotation) {
            return new Binder<InternalTenantContextBinder, InternalTenantContext>(){

                public void bind(SQLStatement q, InternalTenantContextBinder bind, InternalTenantContext context) {
                    if (context.getTenantRecordId() == null) {
                        q.bindNull("tenantRecordId", 4);
                    } else {
                        q.bind("tenantRecordId", context.getTenantRecordId());
                    }
                    if (context.getAccountRecordId() == null) {
                        q.bindNull("accountRecordId", 4);
                    } else {
                        q.bind("accountRecordId", context.getAccountRecordId());
                    }
                    if (context instanceof InternalCallContext) {
                        InternalCallContext callContext = (InternalCallContext)context;
                        q.bind("userName", callContext.getCreatedBy());
                        if (callContext.getCreatedDate() == null) {
                            q.bindNull("createdDate", 91);
                        } else {
                            q.bind("createdDate", callContext.getCreatedDate().toDate());
                        }
                        if (callContext.getUpdatedDate() == null) {
                            q.bindNull("updatedDate", 91);
                        } else {
                            q.bind("updatedDate", callContext.getUpdatedDate().toDate());
                        }
                        q.bind("reasonCode", callContext.getReasonCode());
                        q.bind("comments", callContext.getComments());
                        q.bind("userToken", callContext.getUserToken() != null ? callContext.getUserToken().toString() : null);
                    }
                }
            };
        }
    }
}

