/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.config.definition;

import java.util.List;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.config.definition.KillbillConfig;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.Description;
import org.skife.config.Param;
import org.skife.config.TimeSpan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PaymentConfig
extends KillbillConfig {
    @Config(value={"org.killbill.payment.retry.days"})
    @Default(value="8,8,8")
    @Description(value="Specify the number of payment retries along with the interval in days between payment retries when payment failures occur")
    public List<Integer> getPaymentFailureRetryDays();

    @Config(value={"org.killbill.payment.retry.days"})
    @Default(value="8,8,8")
    @Description(value="Specify the number of payment retries along with the interval in days between payment retries when payment failures occur")
    public List<Integer> getPaymentFailureRetryDays(@Param(value="dummy") InternalTenantContext var1);

    @Config(value={"org.killbill.payment.failure.retry.start.sec"})
    @Default(value="300")
    @Description(value="Specify the interval of time in seconds before retrying a payment that failed due to a plugin failure (gateway is down, transient error, ...)")
    public int getPluginFailureInitialRetryInSec();

    @Config(value={"org.killbill.payment.failure.retry.start.sec"})
    @Default(value="300")
    @Description(value="Specify the interval of time in seconds before retrying a payment that failed due to a plugin failure (gateway is down, transient error, ...)")
    public int getPluginFailureInitialRetryInSec(@Param(value="dummy") InternalTenantContext var1);

    @Config(value={"org.killbill.payment.failure.retry.multiplier"})
    @Default(value="2")
    @Description(value="Specify the multiplier to apply between in retry before retrying a payment that failed due to a plugin failure (gateway is down, transient error, ...)")
    public int getPluginFailureRetryMultiplier();

    @Config(value={"org.killbill.payment.failure.retry.multiplier"})
    @Default(value="2")
    @Description(value="Specify the multiplier to apply between in retry before retrying a payment that failed due to a plugin failure (gateway is down, transient error, ...)")
    public int getPluginFailureRetryMultiplier(@Param(value="dummy") InternalTenantContext var1);

    @Config(value={"org.killbill.payment.janitor.unknown.retries"})
    @Default(value="5m,1h,1d,1d,1d,1d,1d")
    @Description(value="Delay before which unresolved transactions should be retried")
    public List<TimeSpan> getUnknownTransactionsRetries();

    @Config(value={"org.killbill.payment.janitor.unknown.retries"})
    @Default(value="5m,1h,1d,1d,1d,1d,1d")
    @Description(value="Delay before which unresolved transactions should be retried")
    public List<TimeSpan> getUnknownTransactionsRetries(@Param(value="dummy") InternalTenantContext var1);

    @Config(value={"org.killbill.payment.janitor.pending.retries"})
    @Default(value="1h, 1d")
    @Description(value="Delay before which unresolved transactions should be retried")
    public List<TimeSpan> getPendingTransactionsRetries();

    @Config(value={"org.killbill.payment.janitor.pending.retries"})
    @Default(value="1h, 1d")
    @Description(value="Delay before which unresolved transactions should be retried")
    public List<TimeSpan> getPendingTransactionsRetries(@Param(value="dummy") InternalTenantContext var1);

    @Config(value={"org.killbill.payment.failure.retry.max.attempts"})
    @Default(value="8")
    @Description(value="Specify the max number of attempts before retrying a payment that failed due to a plugin failure (gateway is down, transient error, ...)")
    public int getPluginFailureRetryMaxAttempts();

    @Config(value={"org.killbill.payment.failure.retry.max.attempts"})
    @Default(value="8")
    @Description(value="Specify the max number of attempts before retrying a payment that failed due to a plugin failure (gateway is down, transient error, ...)")
    public int getPluginFailureRetryMaxAttempts(@Param(value="dummy") InternalTenantContext var1);

    @Config(value={"org.killbill.payment.invoice.plugin"})
    @Default(value="")
    @Description(value="Default payment control plugin names")
    public List<String> getPaymentControlPluginNames();

    @Config(value={"org.killbill.payment.invoice.plugin"})
    @Default(value="")
    @Description(value="Default payment control plugin names")
    public List<String> getPaymentControlPluginNames(@Param(value="dummy") InternalTenantContext var1);

    @Config(value={"org.killbill.payment.janitor.rate"})
    @Default(value="1h")
    @Description(value="Rate at which janitor tasks are scheduled")
    public TimeSpan getJanitorRunningRate();

    @Config(value={"org.killbill.payment.janitor.attempts.delay"})
    @Default(value="12h")
    @Description(value="Delay before which unresolved attempt should be retried")
    public TimeSpan getIncompleteAttemptsTimeSpanDelay();

    @Config(value={"org.killbill.payment.provider.default"})
    @Default(value="__external_payment__")
    @Description(value="Default payment provider to use")
    public String getDefaultPaymentProvider();

    @Config(value={"org.killbill.payment.plugin.timeout"})
    @Default(value="30s")
    @Description(value="Timeout for each payment attempt")
    public TimeSpan getPaymentPluginTimeout();

    @Config(value={"org.killbill.payment.plugin.threads.nb"})
    @Default(value="100")
    @Description(value="Number of threads for plugin executor dispatcher")
    public int getPaymentPluginThreadNb();

    @Config(value={"org.killbill.payment.globalLock.retries"})
    @Default(value="50")
    @Description(value="Maximum number of times the system will retry to grab global lock (with a 100ms wait each time)")
    public int getMaxGlobalLockRetries();
}

