/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.config.definition;

import org.killbill.billing.util.config.definition.KillbillConfig;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.DefaultNull;
import org.skife.config.Description;

public interface SecurityConfig
extends KillbillConfig {
    @Config(value={"org.killbill.security.shiroResourcePath"})
    @Default(value="classpath:shiro.ini")
    @Description(value="Path to the shiro.ini file (classpath, url or file resource)")
    public String getShiroResourcePath();

    @Config(value={"org.killbill.security.shiroNbHashIterations"})
    @Default(value="200000")
    @Description(value="Sets the number of times submitted credentials will be hashed before comparing to the credentials stored in the system")
    public Integer getShiroNbHashIterations();

    @Config(value={"org.killbill.security.ldap.userDnTemplate"})
    @DefaultNull
    @Description(value="LDAP server's User DN format (e.g. uid={0},ou=users,dc=mycompany,dc=com)")
    public String getShiroLDAPUserDnTemplate();

    @Config(value={"org.killbill.security.ldap.dnSearchTemplate"})
    @DefaultNull
    @Description(value="LDAP server's DN search template (e.g. sAMAccountName={0}) for search-then-bind authentication (in case a static DN format template isn't enough)")
    public String getShiroLDAPDnSearchTemplate();

    @Config(value={"org.killbill.security.ldap.searchBase"})
    @DefaultNull
    @Description(value="LDAP search base to use")
    public String getShiroLDAPSearchBase();

    @Config(value={"org.killbill.security.ldap.groupSearchFilter"})
    @Default(value="memberOf=uid={0}")
    @Description(value="LDAP search filter to use to find groups (e.g. memberOf=uid={0},ou=users,dc=mycompany,dc=com)")
    public String getShiroLDAPGroupSearchFilter();

    @Config(value={"org.killbill.security.ldap.groupNameId"})
    @Default(value="memberOf")
    @Description(value="Group name attribute ID in LDAP")
    public String getShiroLDAPGroupNameID();

    @Config(value={"org.killbill.security.ldap.permissionsByGroup"})
    @Default(value="admin = *:*\nfinance = invoice:*, payment:*\nsupport = entitlement:*, invoice:item_adjust")
    @Description(value="LDAP permissions by LDAP group")
    public String getShiroLDAPPermissionsByGroup();

    @Config(value={"org.killbill.security.ldap.url"})
    @Default(value="ldap://127.0.0.1:389")
    @Description(value="LDAP server url")
    public String getShiroLDAPUrl();

    @Config(value={"org.killbill.security.ldap.systemUsername"})
    @DefaultNull
    @Description(value="LDAP username")
    public String getShiroLDAPSystemUsername();

    @Config(value={"org.killbill.security.ldap.systemPassword"})
    @DefaultNull
    @Description(value="LDAP password")
    public String getShiroLDAPSystemPassword();

    @Config(value={"org.killbill.security.ldap.authenticationMechanism"})
    @Default(value="simple")
    @Description(value="LDAP authentication mechanism (e.g. DIGEST-MD5)")
    public String getShiroLDAPAuthenticationMechanism();

    @Config(value={"org.killbill.security.ldap.disableSSLCheck"})
    @Default(value="false")
    @Description(value="Whether to ignore SSL certificates checks")
    public boolean disableShiroLDAPSSLCheck();

    @Config(value={"org.killbill.security.ldap.followReferrals"})
    @Default(value="false")
    @Description(value="Whether to follow referrals")
    public boolean followShiroLDAPReferrals();

    @Config(value={"org.killbill.security.okta.url"})
    @DefaultNull
    @Description(value="Okta org full url")
    public String getShiroOktaUrl();

    @Config(value={"org.killbill.security.okta.apiToken"})
    @DefaultNull
    @Description(value="Okta API token")
    public String getShiroOktaAPIToken();

    @Config(value={"org.killbill.security.okta.permissionsByGroup"})
    @Default(value="admin = *:*\nfinance = invoice:*, payment:*\nsupport = entitlement:*, invoice:item_adjust")
    @Description(value="Okta permissions by Okta group")
    public String getShiroOktaPermissionsByGroup();
}

