/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.config.tenant;

import com.google.inject.Inject;
import java.io.IOException;
import javax.annotation.Nullable;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.cache.TenantConfigCacheLoader;
import org.killbill.billing.util.config.tenant.PerTenantConfig;
import org.killbill.billing.util.jackson.ObjectMapper;

public class CacheConfig {
    private final CacheController<Long, PerTenantConfig> cacheController;
    private final CacheLoaderArgument cacheLoaderArgument;
    private final ObjectMapper objectMapper;

    @Inject
    public CacheConfig(CacheControllerDispatcher cacheControllerDispatcher) {
        this.cacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_CONFIG);
        this.objectMapper = new ObjectMapper();
        this.cacheLoaderArgument = this.initializeCacheLoaderArgument();
    }

    public PerTenantConfig getPerTenantConfig(InternalTenantContext tenantContext) {
        PerTenantConfig perTenantConfig = this.cacheController.get(tenantContext.getTenantRecordId(), this.cacheLoaderArgument);
        return perTenantConfig;
    }

    public void clearPerTenantConfig(InternalTenantContext tenantContext) {
        this.cacheController.remove(tenantContext.getTenantRecordId());
    }

    private CacheLoaderArgument initializeCacheLoaderArgument() {
        TenantConfigCacheLoader.LoaderCallback loaderCallback = new TenantConfigCacheLoader.LoaderCallback(){

            public PerTenantConfig loadConfig(@Nullable String inputJson) throws IOException {
                return inputJson != null ? (PerTenantConfig)CacheConfig.this.objectMapper.readValue(inputJson, PerTenantConfig.class) : new PerTenantConfig();
            }
        };
        Object[] args = new Object[]{loaderCallback};
        ObjectType irrelevant = null;
        InternalTenantContext notUsed = null;
        return new CacheLoaderArgument(irrelevant, args, notUsed);
    }
}

