/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.entity.EntityBase;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.dao.CustomFieldModelDao;

public class StringCustomField
extends EntityBase
implements CustomField {
    private final String fieldName;
    private final String fieldValue;
    private final UUID objectId;
    private final ObjectType objectType;

    public StringCustomField(String name, String value, ObjectType objectType, UUID objectId, DateTime createdDate) {
        this(UUIDs.randomUUID(), name, value, objectType, objectId, createdDate);
    }

    public StringCustomField(UUID id, String name, String value, ObjectType objectType, UUID objectId, DateTime createdDate) {
        super(id, createdDate, createdDate);
        this.fieldName = name;
        this.fieldValue = value;
        this.objectId = objectId;
        this.objectType = objectType;
    }

    public StringCustomField(CustomFieldModelDao input) {
        this(input.getId(), input.getFieldName(), input.getFieldValue(), input.getObjectType(), input.getObjectId(), input.getCreatedDate());
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StringCustomField");
        sb.append("{fieldName='").append(this.fieldName).append('\'');
        sb.append(", fieldValue='").append(this.fieldValue).append('\'');
        sb.append(", objectId=").append(this.objectId);
        sb.append(", objectType=").append(this.objectType);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringCustomField that = (StringCustomField)((Object)o);
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        if (this.fieldValue != null ? !this.fieldValue.equals(that.fieldValue) : that.fieldValue != null) {
            return false;
        }
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        return this.objectType == that.objectType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + (this.fieldValue != null ? this.fieldValue.hashCode() : 0);
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        return result;
    }
}

