/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.CustomFieldUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.StringCustomField;
import org.killbill.billing.util.customfield.dao.CustomFieldDao;
import org.killbill.billing.util.customfield.dao.CustomFieldModelDao;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCustomFieldUserApi
implements CustomFieldUserApi {
    private static final Function<CustomFieldModelDao, CustomField> CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION = new Function<CustomFieldModelDao, CustomField>(){

        public CustomField apply(CustomFieldModelDao input) {
            return new StringCustomField(input);
        }
    };
    private final InternalCallContextFactory internalCallContextFactory;
    private final CustomFieldDao customFieldDao;

    @Inject
    public DefaultCustomFieldUserApi(InternalCallContextFactory internalCallContextFactory, CustomFieldDao customFieldDao) {
        this.internalCallContextFactory = internalCallContextFactory;
        this.customFieldDao = customFieldDao;
    }

    public Pagination<CustomField> searchCustomFields(final String searchKey, final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<CustomFieldModelDao, CustomFieldApiException>(){

            @Override
            public Pagination<CustomFieldModelDao> build() {
                return DefaultCustomFieldUserApi.this.customFieldDao.searchCustomFields(searchKey, offset, limit, DefaultCustomFieldUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION);
    }

    public Pagination<CustomField> getCustomFields(final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException(limit, new DefaultPaginationHelper.SourcePaginationBuilder<CustomFieldModelDao, CustomFieldApiException>(){

            @Override
            public Pagination<CustomFieldModelDao> build() {
                return DefaultCustomFieldUserApi.this.customFieldDao.get(offset, limit, DefaultCustomFieldUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION);
    }

    public void addCustomFields(List<CustomField> customFields, CallContext context) throws CustomFieldApiException {
        HashMap<UUID, ObjectType> mapping = new HashMap<UUID, ObjectType>();
        for (CustomField customField : customFields) {
            mapping.put(customField.getObjectId(), customField.getObjectType());
        }
        LinkedList<CustomFieldModelDao> all = new LinkedList<CustomFieldModelDao>();
        for (UUID cur : mapping.keySet()) {
            ObjectType type = (ObjectType)mapping.get(cur);
            all.addAll(this.customFieldDao.getCustomFieldsForObject(cur, type, (InternalTenantContext)this.internalCallContextFactory.createInternalCallContext(cur, type, context)));
        }
        LinkedList<CustomField> linkedList = new LinkedList<CustomField>();
        for (final CustomField cur : customFields) {
            CustomFieldModelDao match = (CustomFieldModelDao)Iterables.tryFind(all, (Predicate)new Predicate<CustomFieldModelDao>(){

                public boolean apply(CustomFieldModelDao input) {
                    return input.getObjectId().equals(cur.getObjectId()) && input.getObjectType() == cur.getObjectType() && input.getFieldName().equals(cur.getFieldName());
                }
            }).orNull();
            if (match != null) {
                throw new CustomFieldApiException(ErrorCode.CUSTOM_FIELD_ALREADY_EXISTS, new Object[]{match.getId()});
            }
            linkedList.add(cur);
        }
        for (final CustomField cur : linkedList) {
            this.customFieldDao.create(new CustomFieldModelDao(context.getCreatedDate(), cur.getFieldName(), cur.getFieldValue(), cur.getObjectId(), cur.getObjectType()), this.internalCallContextFactory.createInternalCallContext(cur.getObjectId(), cur.getObjectType(), context));
        }
    }

    public void removeCustomFields(List<CustomField> customFields, CallContext context) throws CustomFieldApiException {
        for (CustomField cur : customFields) {
            this.customFieldDao.deleteCustomField(cur.getId(), this.internalCallContextFactory.createInternalCallContext(cur.getObjectId(), cur.getObjectType(), context));
        }
    }

    public List<CustomField> getCustomFieldsForObject(UUID objectId, ObjectType objectType, TenantContext context) {
        return this.withCustomFieldsTransform(this.customFieldDao.getCustomFieldsForObject(objectId, objectType, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)));
    }

    public List<CustomField> getCustomFieldsForAccountType(UUID accountId, ObjectType objectType, TenantContext context) {
        return this.withCustomFieldsTransform(this.customFieldDao.getCustomFieldsForAccountType(objectType, this.internalCallContextFactory.createInternalTenantContext(accountId, context)));
    }

    public List<CustomField> getCustomFieldsForAccount(UUID accountId, TenantContext context) {
        return this.withCustomFieldsTransform(this.customFieldDao.getCustomFieldsForAccount(this.internalCallContextFactory.createInternalTenantContext(accountId, context)));
    }

    private List<CustomField> withCustomFieldsTransform(Collection<CustomFieldModelDao> input) {
        return ImmutableList.copyOf((Collection)Collections2.transform(input, CUSTOM_FIELD_MODEL_DAO_CUSTOM_FIELD_FUNCTION));
    }
}

