/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.customfield.dao;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.events.BusEventBase;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.customfield.CustomField;
import org.killbill.billing.util.customfield.api.DefaultCustomFieldCreationEvent;
import org.killbill.billing.util.customfield.api.DefaultCustomFieldDeletionEvent;
import org.killbill.billing.util.customfield.dao.CustomFieldDao;
import org.killbill.billing.util.customfield.dao.CustomFieldModelDao;
import org.killbill.billing.util.customfield.dao.CustomFieldSqlDao;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import org.killbill.billing.util.entity.dao.EntityDaoBase;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCustomFieldDao
extends EntityDaoBase<CustomFieldModelDao, CustomField, CustomFieldApiException>
implements CustomFieldDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultCustomFieldDao.class);
    private final PersistentBus bus;

    @Inject
    public DefaultCustomFieldDao(IDBI dbi, Clock clock, CacheControllerDispatcher controllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory, PersistentBus bus) {
        super(new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, controllerDispatcher, nonEntityDao, internalCallContextFactory), CustomFieldSqlDao.class);
        this.bus = bus;
    }

    @Override
    public List<CustomFieldModelDao> getCustomFieldsForObject(final UUID objectId, final ObjectType objectType, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<List<CustomFieldModelDao>>(){

            @Override
            public List<CustomFieldModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class).getCustomFieldsForObject(objectId, objectType, context);
            }
        });
    }

    @Override
    public List<CustomFieldModelDao> getCustomFieldsForAccountType(final ObjectType objectType, InternalTenantContext context) {
        List<CustomFieldModelDao> allFields = this.getCustomFieldsForAccount(context);
        return ImmutableList.copyOf((Collection)Collections2.filter(allFields, (Predicate)new Predicate<CustomFieldModelDao>(){

            public boolean apply(@Nullable CustomFieldModelDao input) {
                return input.getObjectType() == objectType;
            }
        }));
    }

    @Override
    public List<CustomFieldModelDao> getCustomFieldsForAccount(final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<List<CustomFieldModelDao>>(){

            @Override
            public List<CustomFieldModelDao> inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                return entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class).getByAccountRecordId(context);
            }
        });
    }

    @Override
    public void deleteCustomField(final UUID customFieldId, final InternalCallContext context) throws CustomFieldApiException {
        this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<Void>(){

            @Override
            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                CustomFieldSqlDao sqlDao = entitySqlDaoWrapperFactory.become(CustomFieldSqlDao.class);
                CustomFieldModelDao customField = (CustomFieldModelDao)sqlDao.getById(customFieldId.toString(), (InternalTenantContext)context);
                sqlDao.markTagAsDeleted(customFieldId.toString(), context);
                DefaultCustomFieldDao.this.postBusEventFromTransaction(customField, customField, ChangeType.DELETE, entitySqlDaoWrapperFactory, context);
                return null;
            }
        });
    }

    @Override
    protected CustomFieldApiException generateAlreadyExistsException(CustomFieldModelDao entity, InternalCallContext context) {
        return new CustomFieldApiException(ErrorCode.CUSTOM_FIELD_ALREADY_EXISTS, new Object[]{entity.getId()});
    }

    @Override
    protected void postBusEventFromTransaction(CustomFieldModelDao customField, CustomFieldModelDao savedCustomField, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
        BusEventBase customFieldEvent = null;
        switch (changeType) {
            case INSERT: {
                customFieldEvent = new DefaultCustomFieldCreationEvent(customField.getId(), customField.getObjectId(), customField.getObjectType(), context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            case DELETE: {
                customFieldEvent = new DefaultCustomFieldDeletionEvent(customField.getId(), customField.getObjectId(), customField.getObjectType(), context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.bus.postFromTransaction((BusEvent)customFieldEvent, entitySqlDaoWrapperFactory.getHandle().getConnection());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post tag event for customFieldId='{}'", (Object)customField.getId().toString(), (Object)e);
        }
    }

    @Override
    public Pagination<CustomFieldModelDao> searchCustomFields(final String searchKey, Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(CustomFieldSqlDao.class, new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<CustomFieldModelDao, CustomField, CustomFieldSqlDao>(){

            @Override
            public Long getCount(CustomFieldSqlDao customFieldSqlDao, InternalTenantContext context) {
                return customFieldSqlDao.getSearchCount(searchKey, String.format("%%%s%%", searchKey), context);
            }

            @Override
            public Iterator<CustomFieldModelDao> build(CustomFieldSqlDao customFieldSqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return customFieldSqlDao.search(searchKey, String.format("%%%s%%", searchKey), offset, limit, ordering.toString(), context);
            }
        }, offset, limit, context);
    }
}

