/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.dao.AuditLogModelDao;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.dao.EntityAudit;
import org.killbill.billing.util.dao.MapperBase;
import org.killbill.billing.util.dao.TableName;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditLogModelDaoMapper
extends MapperBase
implements ResultSetMapper<AuditLogModelDao> {
    public AuditLogModelDao map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        UUID id = this.getUUID(r, "id");
        String tableName = r.getString("table_name");
        long targetRecordId = r.getLong("target_record_id");
        String changeType = r.getString("change_type");
        DateTime createdDate = this.getDateTime(r, "created_date");
        String createdBy = r.getString("created_by");
        String reasonCode = r.getString("reason_code");
        String comments = r.getString("comments");
        UUID userToken = this.getUUID(r, "user_token");
        EntityAudit entityAudit = new EntityAudit(id, TableName.valueOf(tableName), targetRecordId, ChangeType.valueOf((String)changeType), createdDate);
        DefaultCallContext callContext = new DefaultCallContext(null, createdBy, createdDate, reasonCode, comments, userToken);
        return new AuditLogModelDao(entityAudit, (CallContext)callContext);
    }
}

