/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.dao.NonEntitySqlDao;
import org.killbill.billing.util.dao.TableName;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNonEntityDao
implements NonEntityDao {
    private final NonEntitySqlDao nonEntitySqlDao;
    private final WithCaching<String, Long> withCachingObjectId;
    private final WithCaching<String, UUID> withCachingRecordId;

    @Inject
    public DefaultNonEntityDao(IDBI dbi) {
        this.nonEntitySqlDao = (NonEntitySqlDao)dbi.onDemand(NonEntitySqlDao.class);
        this.withCachingObjectId = new WithCaching();
        this.withCachingRecordId = new WithCaching();
    }

    @Override
    public Long retrieveRecordIdFromObject(@Nullable UUID objectId, ObjectType objectType, @Nullable CacheController<String, Long> cache) {
        return this.retrieveRecordIdFromObjectInTransaction(objectId, objectType, cache, null);
    }

    @Override
    public Long retrieveRecordIdFromObjectInTransaction(final @Nullable UUID objectId, ObjectType objectType, @Nullable CacheController<String, Long> cache, final @Nullable Handle handle) {
        if (objectId == null) {
            return null;
        }
        final TableName tableName = TableName.fromObjectType(objectType);
        Preconditions.checkNotNull((Object)((Object)tableName), (String)"%s is not a valid ObjectType", (Object)objectType);
        return (Long)((WithCaching)this.withCachingObjectId).withCaching(new OperationRetrieval<Long>(){

            @Override
            public Long doRetrieve(ObjectType objectType) {
                NonEntitySqlDao inTransactionNonEntitySqlDao = handle == null ? DefaultNonEntityDao.this.nonEntitySqlDao : (NonEntitySqlDao)SqlObjectBuilder.attach((Handle)handle, NonEntitySqlDao.class);
                return inTransactionNonEntitySqlDao.getRecordIdFromObject(objectId.toString(), tableName.getTableName());
            }
        }, objectId.toString(), objectType, tableName, cache);
    }

    @Override
    public Long retrieveAccountRecordIdFromObject(@Nullable UUID objectId, ObjectType objectType, @Nullable CacheController<String, Long> cache) {
        return this.retrieveAccountRecordIdFromObjectInTransaction(objectId, objectType, cache, null);
    }

    @Override
    public Long retrieveAccountRecordIdFromObjectInTransaction(@Nullable UUID objectId, ObjectType objectType, @Nullable CacheController<String, Long> cache, final @Nullable Handle handle) {
        final TableName tableName = TableName.fromObjectType(objectType);
        Preconditions.checkNotNull((Object)((Object)tableName), (String)"%s is not a valid ObjectType", (Object)objectType);
        final String objectIdOrNull = objectId != null ? objectId.toString() : null;
        return (Long)((WithCaching)this.withCachingObjectId).withCaching(new OperationRetrieval<Long>(){

            @Override
            public Long doRetrieve(ObjectType objectType) {
                NonEntitySqlDao inTransactionNonEntitySqlDao = handle == null ? DefaultNonEntityDao.this.nonEntitySqlDao : (NonEntitySqlDao)SqlObjectBuilder.attach((Handle)handle, NonEntitySqlDao.class);
                switch (tableName) {
                    case TENANT: 
                    case TAG_DEFINITIONS: 
                    case TAG_DEFINITION_HISTORY: {
                        return null;
                    }
                    case ACCOUNT: {
                        return inTransactionNonEntitySqlDao.getAccountRecordIdFromAccount(objectIdOrNull);
                    }
                }
                return inTransactionNonEntitySqlDao.getAccountRecordIdFromObjectOtherThanAccount(objectIdOrNull, tableName.getTableName());
            }
        }, objectIdOrNull, objectType, tableName, cache);
    }

    @Override
    public Long retrieveTenantRecordIdFromObject(@Nullable UUID objectId, ObjectType objectType, @Nullable CacheController<String, Long> cache) {
        return this.retrieveTenantRecordIdFromObjectInTransaction(objectId, objectType, cache, null);
    }

    @Override
    public Long retrieveTenantRecordIdFromObjectInTransaction(final @Nullable UUID objectId, ObjectType objectType, @Nullable CacheController<String, Long> cache, final @Nullable Handle handle) {
        final TableName tableName = TableName.fromObjectType(objectType);
        Preconditions.checkNotNull((Object)((Object)tableName), (String)"%s is not a valid ObjectType", (Object)objectType);
        final String objectIdOrNull = objectId != null ? objectId.toString() : null;
        return (Long)((WithCaching)this.withCachingObjectId).withCaching(new OperationRetrieval<Long>(){

            @Override
            public Long doRetrieve(ObjectType objectType) {
                NonEntitySqlDao inTransactionNonEntitySqlDao = handle == null ? DefaultNonEntityDao.this.nonEntitySqlDao : (NonEntitySqlDao)SqlObjectBuilder.attach((Handle)handle, NonEntitySqlDao.class);
                switch (tableName) {
                    case TENANT: {
                        return objectId == null ? Long.valueOf(0L) : inTransactionNonEntitySqlDao.getTenantRecordIdFromTenant(objectIdOrNull);
                    }
                }
                return inTransactionNonEntitySqlDao.getTenantRecordIdFromObjectOtherThanTenant(objectIdOrNull, tableName.getTableName());
            }
        }, objectIdOrNull, objectType, tableName, cache);
    }

    @Override
    public UUID retrieveIdFromObject(Long recordId, ObjectType objectType, @Nullable CacheController<String, UUID> cache) {
        return this.retrieveIdFromObjectInTransaction(recordId, objectType, cache, null);
    }

    @Override
    public UUID retrieveIdFromObjectInTransaction(final Long recordId, ObjectType objectType, @Nullable CacheController<String, UUID> cache, final @Nullable Handle handle) {
        if (objectType == ObjectType.TENANT && InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID.equals(recordId)) {
            return null;
        }
        final TableName tableName = TableName.fromObjectType(objectType);
        Preconditions.checkNotNull((Object)((Object)tableName), (String)"%s is not a valid ObjectType", (Object)objectType);
        return (UUID)((WithCaching)this.withCachingRecordId).withCaching(new OperationRetrieval<UUID>(){

            @Override
            public UUID doRetrieve(ObjectType objectType) {
                NonEntitySqlDao inTransactionNonEntitySqlDao = handle == null ? DefaultNonEntityDao.this.nonEntitySqlDao : (NonEntitySqlDao)SqlObjectBuilder.attach((Handle)handle, NonEntitySqlDao.class);
                return inTransactionNonEntitySqlDao.getIdFromObject(recordId, tableName.getTableName());
            }
        }, String.valueOf(recordId), objectType, tableName, cache);
    }

    @Override
    public Long retrieveLastHistoryRecordIdFromTransaction(@Nullable Long targetRecordId, TableName tableName, NonEntitySqlDao transactional) {
        return transactional.getLastHistoryRecordId(targetRecordId, tableName.getTableName());
    }

    @Override
    public Long retrieveHistoryTargetRecordId(@Nullable Long recordId, TableName tableName) {
        return this.nonEntitySqlDao.getHistoryTargetRecordId(recordId, tableName.getTableName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WithCaching<TypeIn, TypeOut> {
        private WithCaching() {
        }

        private TypeOut withCaching(final OperationRetrieval<TypeOut> op, @Nullable TypeIn objectOrRecordId, final ObjectType objectType, TableName tableName, @Nullable CacheController<TypeIn, TypeOut> cache) {
            Profiling prof = new Profiling();
            if (objectOrRecordId == null) {
                return null;
            }
            if (cache != null) {
                TypeIn key = cache.getCacheType().isKeyPrefixedWithTableName() ? (Object)((Object)tableName) + "::" + objectOrRecordId.toString() : objectOrRecordId;
                return cache.get(key, new CacheLoaderArgument(objectType));
            }
            Object result = prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO_DETAILS, "NonEntityDao (type = " + objectType + ") cache miss", new Profiling.WithProfilingCallback<TypeOut, RuntimeException>(){

                public TypeOut execute() throws RuntimeException {
                    return op.doRetrieve(objectType);
                }
            });
            return (TypeOut)result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface OperationRetrieval<TypeOut> {
        public TypeOut doRetrieve(ObjectType var1);
    }
}

