/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import org.killbill.billing.util.dao.EntityHistoryModelDao;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.sqlobject.BindingAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BindingAnnotation(value=EntityHistoryBinderFactory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface EntityHistoryBinder {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntityHistoryBinderFactory<M extends EntityModelDao<E>, E extends Entity>
    implements BinderFactory {
        private static final Logger logger = LoggerFactory.getLogger(EntityHistoryBinder.class);

        public Binder build(Annotation annotation) {
            return new Binder<EntityHistoryBinder, EntityHistoryModelDao<M, E>>(){

                public void bind(SQLStatement<?> q, EntityHistoryBinder bind, EntityHistoryModelDao<M, E> history) {
                    try {
                        PropertyDescriptor[] props;
                        Object arg = history.getEntity();
                        BeanInfo infos = Introspector.getBeanInfo(arg.getClass());
                        for (PropertyDescriptor prop : props = infos.getPropertyDescriptors()) {
                            q.bind(prop.getName(), prop.getReadMethod().invoke(arg, new Object[0]));
                        }
                        q.bind("id", (Object)history.getId());
                        q.bind("targetRecordId", history.getTargetRecordId());
                        q.bind("changeType", history.getChangeType().toString());
                    }
                    catch (IntrospectionException e) {
                        logger.warn(e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        logger.warn(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        logger.warn(e.getMessage());
                    }
                }
            };
        }
    }
}

