/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.dao.EntityHistoryModelDao;
import org.killbill.billing.util.dao.MapperBase;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntityModelDaoBase;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityHistoryModelDaoMapper<M extends EntityModelDao<E>, E extends Entity>
extends MapperBase
implements ResultSetMapper<EntityHistoryModelDao<M, E>> {
    private final ResultSetMapper<M> entityMapper;

    public EntityHistoryModelDaoMapper(ResultSetMapper<M> entityMapper) {
        this.entityMapper = entityMapper;
    }

    public EntityHistoryModelDao<M, E> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        UUID id = this.getUUID(r, "id");
        long targetRecordId = r.getLong("target_record_id");
        String changeType = r.getString("change_type");
        DateTime createdDate = this.getDateTime(r, "created_date");
        EntityModelDao entityModelDao = (EntityModelDao)this.entityMapper.map(index, r, ctx);
        ((EntityModelDaoBase)((Object)entityModelDao)).setId(null);
        ((EntityModelDaoBase)((Object)entityModelDao)).setRecordId(targetRecordId);
        if (entityModelDao.getAccountRecordId() == null) {
            ((EntityModelDaoBase)((Object)entityModelDao)).setAccountRecordId(targetRecordId);
        }
        return new EntityHistoryModelDao(id, entityModelDao, targetRecordId, ChangeType.valueOf((String)changeType), createdDate);
    }
}

