/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.email;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.util.email.EmailApiException;
import org.killbill.billing.util.email.EmailConfig;
import org.killbill.billing.util.email.EmailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEmailSender
implements EmailSender {
    private final Logger log = LoggerFactory.getLogger(EmailSender.class);
    private final EmailConfig config;

    @Inject
    public DefaultEmailSender(EmailConfig emailConfig) {
        this.config = emailConfig;
    }

    public void sendHTMLEmail(List<String> to, List<String> cc, String subject, String htmlBody) throws EmailApiException {
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHtmlMsg(htmlBody);
        }
        catch (EmailException e) {
            throw new EmailApiException((Throwable)e, ErrorCode.EMAIL_SENDING_FAILED, new Object[0]);
        }
        this.sendEmail(to, cc, subject, (Email)email);
    }

    public void sendPlainTextEmail(List<String> to, List<String> cc, String subject, String body) throws IOException, EmailApiException {
        SimpleEmail email = new SimpleEmail();
        try {
            email.setMsg(body);
        }
        catch (EmailException e) {
            throw new EmailApiException((Throwable)e, ErrorCode.EMAIL_SENDING_FAILED, new Object[0]);
        }
        this.sendEmail(to, cc, subject, (Email)email);
    }

    private void sendEmail(List<String> to, List<String> cc, String subject, Email email) throws EmailApiException {
        try {
            email.setSmtpPort(this.config.getSmtpPort());
            if (this.config.useSmtpAuth()) {
                email.setAuthentication(this.config.getSmtpUserName(), this.config.getSmtpPassword());
            }
            email.setHostName(this.config.getSmtpServerName());
            email.setFrom(this.config.getDefaultFrom());
            email.setSubject(subject);
            if (to != null) {
                for (String recipient : to) {
                    email.addTo(recipient);
                }
            }
            if (cc != null) {
                for (String recipient : cc) {
                    email.addCc(recipient);
                }
            }
            email.setSSL(this.config.useSSL());
            this.log.info("Sending email to='{}', cc='{}', subject='{}'", new Object[]{to, cc, subject});
            email.send();
        }
        catch (EmailException ee) {
            throw new EmailApiException((Throwable)ee, ErrorCode.EMAIL_SENDING_FAILED, new Object[0]);
        }
    }
}

