/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.killbill.billing.util.entity.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPagination<T>
implements Pagination<T>,
Closeable {
    private final Long currentOffset;
    private final Long limit;
    private final Long totalNbRecords;
    private final Long maxNbRecords;
    private final Iterator<T> delegateIterator;

    public static <T> Pagination<T> build(Long offset, Long limit, Collection<T> elements) {
        return DefaultPagination.build(offset, limit, elements.size(), elements);
    }

    public static <T> Pagination<T> build(Long offset, Long limit, Integer maxNbRecords, Collection<T> elements) {
        ImmutableList allResults = ImmutableList.copyOf(elements);
        Object results = offset >= (long)allResults.size() ? ImmutableList.of() : (offset + limit > (long)allResults.size() ? allResults.subList(offset.intValue(), allResults.size()) : allResults.subList(offset.intValue(), offset.intValue() + limit.intValue()));
        return new DefaultPagination(offset, limit, Long.valueOf(results.size()), (long)maxNbRecords, results.iterator());
    }

    public DefaultPagination(Pagination original, Long limit, Iterator<T> delegate) {
        this(original.getCurrentOffset(), limit, original.getTotalNbRecords(), original.getMaxNbRecords(), delegate);
    }

    public DefaultPagination(Long maxNbRecords, Iterator<T> results) {
        this(0L, Long.MAX_VALUE, maxNbRecords, maxNbRecords, results);
    }

    public DefaultPagination(Long currentOffset, Long limit, @Nullable Long totalNbRecords, @Nullable Long maxNbRecords, Iterator<T> delegateIterator) {
        this.currentOffset = currentOffset;
        this.limit = Math.abs(limit);
        this.totalNbRecords = totalNbRecords;
        this.maxNbRecords = maxNbRecords;
        this.delegateIterator = delegateIterator;
    }

    @Override
    public void close() throws IOException {
        if (this.delegateIterator instanceof Closeable) {
            ((Closeable)((Object)this.delegateIterator)).close();
        } else {
            while (this.delegateIterator.hasNext()) {
                this.delegateIterator.next();
            }
        }
    }

    public Iterator<T> iterator() {
        return this.delegateIterator;
    }

    public Long getCurrentOffset() {
        return this.currentOffset;
    }

    public Long getNextOffset() {
        long candidate = this.currentOffset + this.limit;
        if (this.totalNbRecords != null && candidate >= this.totalNbRecords) {
            return null;
        }
        return candidate;
    }

    public Long getMaxNbRecords() {
        return this.maxNbRecords;
    }

    public Long getTotalNbRecords() {
        return this.totalNbRecords;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultPagination{");
        sb.append("currentOffset=").append(this.currentOffset);
        sb.append(", nextOffset=").append(this.getNextOffset());
        sb.append(", totalNbRecords=").append(this.totalNbRecords);
        sb.append(", maxNbRecords=").append(this.maxNbRecords);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPagination that = (DefaultPagination)o;
        if (this.totalNbRecords != null ? !this.totalNbRecords.equals(that.totalNbRecords) : that.totalNbRecords != null) {
            return false;
        }
        if (this.maxNbRecords != null ? !this.maxNbRecords.equals(that.maxNbRecords) : that.maxNbRecords != null) {
            return false;
        }
        if (this.currentOffset != null ? !this.currentOffset.equals(that.currentOffset) : that.currentOffset != null) {
            return false;
        }
        return !(this.delegateIterator != null ? !ImmutableList.copyOf(this.delegateIterator).equals((Object)ImmutableList.copyOf(that.delegateIterator)) : that.delegateIterator != null);
    }

    public int hashCode() {
        int result = this.currentOffset != null ? this.currentOffset.hashCode() : 0;
        result = 31 * result + (this.totalNbRecords != null ? this.totalNbRecords.hashCode() : 0);
        result = 31 * result + (this.maxNbRecords != null ? this.maxNbRecords.hashCode() : 0);
        result = 31 * result + (this.delegateIterator != null ? this.delegateIterator.hashCode() : 0);
        return result;
    }
}

