/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import java.util.Iterator;
import java.util.UUID;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.entity.DefaultPagination;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import org.killbill.billing.util.entity.dao.EntityDao;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityDaoBase<M extends EntityModelDao<E>, E extends Entity, U extends BillingExceptionBase>
implements EntityDao<M, E, U> {
    protected final EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao;
    protected final DefaultPaginationSqlDaoHelper paginationHelper;
    private final Class<? extends EntitySqlDao<M, E>> realSqlDao;

    public EntityDaoBase(EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao, Class<? extends EntitySqlDao<M, E>> realSqlDao) {
        this.transactionalSqlDao = transactionalSqlDao;
        this.realSqlDao = realSqlDao;
        this.paginationHelper = new DefaultPaginationSqlDaoHelper(transactionalSqlDao);
    }

    @Override
    public void create(M entity, InternalCallContext context) throws U {
        EntityModelDao refreshedEntity = (EntityModelDao)this.transactionalSqlDao.execute(this.getCreateEntitySqlDaoTransactionWrapper(entity, context));
        this.transactionalSqlDao.populateCaches(refreshedEntity);
    }

    protected EntitySqlDaoTransactionWrapper<M> getCreateEntitySqlDaoTransactionWrapper(M entity, InternalCallContext context) {
        return new EntitySqlDaoTransactionWrapper<M>((EntityModelDao)entity, context){
            final /* synthetic */ EntityModelDao val$entity;
            final /* synthetic */ InternalCallContext val$context;
            {
                this.val$entity = entityModelDao;
                this.val$context = internalCallContext;
            }

            @Override
            public M inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                if (EntityDaoBase.this.checkEntityAlreadyExists(transactional, this.val$entity, this.val$context)) {
                    throw EntityDaoBase.this.generateAlreadyExistsException(this.val$entity, this.val$context);
                }
                EntityModelDao refreshedEntity = EntityDaoBase.this.createAndRefresh((EntitySqlDao)transactional, this.val$entity, this.val$context);
                EntityDaoBase.this.postBusEventFromTransaction(this.val$entity, refreshedEntity, ChangeType.INSERT, entitySqlDaoWrapperFactory, this.val$context);
                return refreshedEntity;
            }
        };
    }

    protected <F extends EntityModelDao> F createAndRefresh(EntitySqlDao transactional, F entity, InternalCallContext context) throws EntityPersistenceException {
        return (F)((EntityModelDao)transactional.create(entity, context));
    }

    protected boolean checkEntityAlreadyExists(EntitySqlDao<M, E> transactional, M entity, InternalCallContext context) {
        return transactional.getRecordId(entity.getId().toString(), (InternalTenantContext)context) != null;
    }

    protected void postBusEventFromTransaction(M entity, M savedEntity, ChangeType changeType, EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, InternalCallContext context) throws BillingExceptionBase {
    }

    protected abstract U generateAlreadyExistsException(M var1, InternalCallContext var2);

    protected String getNaturalOrderingColumns() {
        return "record_id";
    }

    @Override
    public Long getRecordId(final UUID id, final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<Long>(){

            @Override
            public Long inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                return transactional.getRecordId(id.toString(), context);
            }
        });
    }

    @Override
    public M getByRecordId(final Long recordId, final InternalTenantContext context) {
        return (M)((EntityModelDao)this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<M>(){

            @Override
            public M inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                return transactional.getByRecordId(recordId, context);
            }
        }));
    }

    @Override
    public M getById(final UUID id, final InternalTenantContext context) {
        return (M)((EntityModelDao)this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<M>(){

            @Override
            public M inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                return transactional.getById(id.toString(), context);
            }
        }));
    }

    @Override
    public Pagination<M> getAll(InternalTenantContext context) {
        EntitySqlDao<M, E> sqlDao = this.transactionalSqlDao.onDemandForStreamingResults(this.realSqlDao);
        Long count = sqlDao.getCount(context);
        Iterator<M> results = sqlDao.getAll(context);
        return new DefaultPagination<M>(count, results);
    }

    @Override
    public Pagination<M> get(Long offset, Long limit, InternalTenantContext context) {
        return this.paginationHelper.getPagination(this.realSqlDao, new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<M, E, EntitySqlDao<M, E>>(){

            @Override
            public Long getCount(EntitySqlDao<M, E> sqlDao, InternalTenantContext context) {
                return null;
            }

            @Override
            public Iterator<M> build(EntitySqlDao<M, E> sqlDao, Long offset, Long limit, DefaultPaginationSqlDaoHelper.Ordering ordering, InternalTenantContext context) {
                return sqlDao.get(offset, limit, EntityDaoBase.this.getNaturalOrderingColumns(), ordering.toString(), context);
            }
        }, offset, limit, context);
    }

    @Override
    public Long getCount(final InternalTenantContext context) {
        return this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<Long>(){

            @Override
            public Long inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                return transactional.getCount(context);
            }
        });
    }

    @Override
    public void test(final InternalTenantContext context) {
        this.transactionalSqlDao.execute(new EntitySqlDaoTransactionWrapper<Void>(){

            @Override
            public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                Object transactional = entitySqlDaoWrapperFactory.become(EntityDaoBase.this.realSqlDao);
                transactional.test(context);
                return null;
            }
        });
    }
}

