/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import java.util.Iterator;
import java.util.List;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CachableKey;
import org.killbill.billing.util.dao.AuditSqlDao;
import org.killbill.billing.util.dao.HistorySqlDao;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.Audited;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.commons.jdbi.binder.SmartBindBean;
import org.killbill.commons.jdbi.statement.SmartFetchSize;
import org.killbill.commons.jdbi.template.KillBillSqlDaoStringTemplate;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Define;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.sqlobject.mixins.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@KillBillSqlDaoStringTemplate
public interface EntitySqlDao<M extends EntityModelDao<E>, E extends Entity>
extends AuditSqlDao,
HistorySqlDao<M, E>,
Transactional<EntitySqlDao<M, E>>,
CloseMe {
    @SqlUpdate
    @Audited(value=ChangeType.INSERT)
    public Object create(@SmartBindBean M var1, @SmartBindBean InternalCallContext var2) throws EntityPersistenceException;

    @SqlQuery
    public M getById(@Bind(value="id") String var1, @SmartBindBean InternalTenantContext var2);

    @SqlQuery
    public M getByRecordId(@Bind(value="recordId") Long var1, @SmartBindBean InternalTenantContext var2);

    @SqlQuery
    public List<M> getByAccountRecordId(@SmartBindBean InternalTenantContext var1);

    @SqlQuery
    public List<M> getByAccountRecordIdIncludedDeleted(@SmartBindBean InternalTenantContext var1);

    @SqlQuery
    @Cachable(value=Cachable.CacheType.RECORD_ID)
    public Long getRecordId(@CachableKey(value=1) @Bind(value="id") String var1, @SmartBindBean InternalTenantContext var2);

    @SqlQuery
    @SmartFetchSize(shouldStream=true)
    public Iterator<M> search(@Bind(value="searchKey") String var1, @Bind(value="likeSearchKey") String var2, @Bind(value="offset") Long var3, @Bind(value="rowCount") Long var4, @Define(value="ordering") String var5, @SmartBindBean InternalTenantContext var6);

    @SqlQuery
    public Long getSearchCount(@Bind(value="searchKey") String var1, @Bind(value="likeSearchKey") String var2, @SmartBindBean InternalTenantContext var3);

    @SqlQuery
    @SmartFetchSize(shouldStream=true)
    public Iterator<M> getAll(@SmartBindBean InternalTenantContext var1);

    @SqlQuery
    @SmartFetchSize(shouldStream=true)
    public Iterator<M> get(@Bind(value="offset") Long var1, @Bind(value="rowCount") Long var2, @Define(value="orderBy") String var3, @Define(value="ordering") String var4, @SmartBindBean InternalTenantContext var5);

    @SqlQuery
    public Long getCount(@SmartBindBean InternalTenantContext var1);

    @SqlUpdate
    public void test(@SmartBindBean InternalTenantContext var1);
}

