/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperInvocationHandler;
import org.killbill.clock.Clock;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Transaction;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySqlDaoTransactionalJdbiWrapper {
    private final IDBI dbi;
    private final Clock clock;
    private final CacheControllerDispatcher cacheControllerDispatcher;
    private final NonEntityDao nonEntityDao;
    private final InternalCallContextFactory internalCallContextFactory;

    public EntitySqlDaoTransactionalJdbiWrapper(IDBI dbi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        this.dbi = dbi;
        this.clock = clock;
        this.cacheControllerDispatcher = cacheControllerDispatcher;
        this.nonEntityDao = nonEntityDao;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public <M extends EntityModelDao> void populateCaches(M refreshedEntity) {
        EntitySqlDaoWrapperInvocationHandler.populateCaches(this.cacheControllerDispatcher, refreshedEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReturnType> ReturnType execute(EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper) {
        Handle handle = this.dbi.open();
        try {
            EntitySqlDao entitySqlDao = (EntitySqlDao)handle.attach(InitialEntitySqlDao.class);
            Object object = entitySqlDao.inTransaction(TransactionIsolationLevel.READ_COMMITTED, new JdbiTransaction(handle, entitySqlDaoTransactionWrapper));
            return (ReturnType)object;
        }
        finally {
            handle.close();
        }
    }

    public <M extends EntityModelDao<E>, E extends Entity, T extends EntitySqlDao<M, E>> T onDemandForStreamingResults(Class<T> sqlObjectType) {
        return (T)((EntitySqlDao)this.dbi.onDemand(sqlObjectType));
    }

    public <ReturnType, E extends Exception> ReturnType execute(Class<E> exception, EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper) throws E {
        try {
            return this.execute(entitySqlDaoTransactionWrapper);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause().getClass().isAssignableFrom(exception)) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InitialEntitySqlDao
    extends EntitySqlDao<EntityModelDao<Entity>, Entity> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JdbiTransaction<ReturnType, M extends EntityModelDao<E>, E extends Entity>
    implements Transaction<ReturnType, EntitySqlDao<M, E>> {
        private final Handle h;
        private final EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper;

        JdbiTransaction(Handle h, EntitySqlDaoTransactionWrapper<ReturnType> entitySqlDaoTransactionWrapper) {
            this.h = h;
            this.entitySqlDaoTransactionWrapper = entitySqlDaoTransactionWrapper;
        }

        public ReturnType inTransaction(EntitySqlDao<M, E> transactionalSqlDao, TransactionStatus status) throws Exception {
            EntitySqlDaoWrapperFactory factoryEntitySqlDao = new EntitySqlDaoWrapperFactory(this.h, EntitySqlDaoTransactionalJdbiWrapper.this.clock, EntitySqlDaoTransactionalJdbiWrapper.this.cacheControllerDispatcher, EntitySqlDaoTransactionalJdbiWrapper.this.nonEntityDao, EntitySqlDaoTransactionalJdbiWrapper.this.internalCallContextFactory);
            return this.entitySqlDaoTransactionWrapper.inTransaction(factoryEntitySqlDao);
        }
    }
}

