/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.entity.dao;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CachableKey;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.EntityAudit;
import org.killbill.billing.util.dao.EntityHistoryModelDao;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.Audited;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntitySqlDao;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;
import org.killbill.clock.Clock;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.unstable.BindIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySqlDaoWrapperInvocationHandler<S extends EntitySqlDao<M, E>, M extends EntityModelDao<E>, E extends Entity>
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(EntitySqlDaoWrapperInvocationHandler.class);
    private final Map<String, Annotation[][]> parameterAnnotationsByMethod = new ConcurrentHashMap<String, Annotation[][]>();
    private final Class<S> sqlDaoClass;
    private final S sqlDao;
    private final Handle handle;
    private final CacheControllerDispatcher cacheControllerDispatcher;
    private final Clock clock;
    private final NonEntityDao nonEntityDao;
    private final InternalCallContextFactory internalCallContextFactory;
    private final Profiling<Object, Throwable> prof;

    public EntitySqlDaoWrapperInvocationHandler(Class<S> sqlDaoClass, S sqlDao, Handle handle, Clock clock, @Nullable CacheControllerDispatcher cacheControllerDispatcher, @Nullable NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        this.sqlDaoClass = sqlDaoClass;
        this.sqlDao = sqlDao;
        this.handle = handle;
        this.clock = clock;
        this.cacheControllerDispatcher = cacheControllerDispatcher;
        this.nonEntityDao = nonEntityDao;
        this.internalCallContextFactory = internalCallContextFactory;
        this.prof = new Profiling();
    }

    @Override
    public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable {
        try {
            return this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO, this.getProfilingId(null, method), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

                public Object execute() throws Throwable {
                    return EntitySqlDaoWrapperInvocationHandler.this.invokeSafely(proxy, method, args);
                }
            });
        }
        catch (Throwable t) {
            if (t.getCause() != null && t.getCause().getCause() != null && DBIException.class.isAssignableFrom(t.getCause().getClass())) {
                StatementContext statementContext;
                if (t.getCause() instanceof StatementException && (statementContext = ((StatementException)t.getCause()).getStatementContext()) != null) {
                    Binding binding = statementContext.getBinding();
                    PreparedStatement statement = statementContext.getStatement();
                    if (statement != null) {
                        this.errorDuringTransaction(t.getCause().getCause(), method, statement.toString() + "\n" + binding.toString());
                    } else {
                        this.errorDuringTransaction(t.getCause().getCause(), method, binding.toString());
                    }
                    return null;
                }
                this.errorDuringTransaction(t.getCause().getCause(), method);
            } else if (t.getCause() != null) {
                this.errorDuringTransaction(t.getCause(), method);
            } else {
                this.errorDuringTransaction(t, method);
            }
            return null;
        }
    }

    private void errorDuringTransaction(Throwable t, Method method, String extraErrorMessage) throws Throwable {
        StringBuilder errorMessageBuilder = new StringBuilder("Error during transaction for sql entity {} and method {}");
        if (t instanceof SQLException) {
            SQLException sqlException = (SQLException)t;
            errorMessageBuilder.append(" [SQL DefaultState: ").append(sqlException.getSQLState()).append(", Vendor Error Code: ").append(sqlException.getErrorCode()).append("]");
        }
        if (extraErrorMessage != null) {
            errorMessageBuilder.append("\n").append(extraErrorMessage);
        }
        this.logger.warn(errorMessageBuilder.toString(), this.sqlDaoClass, (Object)method.getName());
        if (!(t instanceof RuntimeException)) {
            throw new RuntimeException(t);
        }
        throw t;
    }

    private void errorDuringTransaction(Throwable t, Method method) throws Throwable {
        this.errorDuringTransaction(t, method, null);
    }

    private Object invokeSafely(Object proxy, Method method, Object[] args) throws Throwable {
        Audited auditedAnnotation = method.getAnnotation(Audited.class);
        Cachable cachableAnnotation = method.getAnnotation(Cachable.class);
        if (auditedAnnotation != null) {
            return this.invokeWithAuditAndHistory(auditedAnnotation, method, args);
        }
        if (cachableAnnotation != null && this.cacheControllerDispatcher != null) {
            return this.invokeWithCaching(cachableAnnotation, method, args);
        }
        return this.invokeRaw(method, args);
    }

    private Object invokeRaw(final Method method, final Object[] args) throws Throwable {
        return this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO_DETAILS, this.getProfilingId("raw", method), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

            public Object execute() throws Throwable {
                Object result = method.invoke((Object)EntitySqlDaoWrapperInvocationHandler.this.sqlDao, args);
                if (result != null && method.getName().equals("getById")) {
                    EntitySqlDaoWrapperInvocationHandler.this.populateCacheOnGetByIdInvocation((EntityModelDao)result);
                }
                return result;
            }
        });
    }

    private Object invokeWithCaching(Cachable cachableAnnotation, Method method, Object[] args) throws Throwable {
        ObjectType objectType = this.getObjectType();
        Cachable.CacheType cacheType = cachableAnnotation.value();
        CacheController cache = this.cacheControllerDispatcher.getCacheController(cacheType);
        if (cache != null && objectType != null) {
            LinkedHashMap<Integer, Object> keyPieces = new LinkedHashMap<Integer, Object>();
            Annotation[][] annotations = this.getAnnotations(method);
            block0: for (int i = 0; i < annotations.length; ++i) {
                for (int j = 0; j < annotations[i].length; ++j) {
                    Annotation annotation = annotations[i][j];
                    if (!CachableKey.class.equals(annotation.annotationType())) continue;
                    keyPieces.put(((CachableKey)annotation).value() - 1, args[i]);
                    continue block0;
                }
            }
            String cacheKey = this.buildCacheKey(keyPieces);
            InternalTenantContext internalTenantContext = (InternalTenantContext)Iterables.find((Iterable)ImmutableList.copyOf((Object[])args), (Predicate)new Predicate<Object>(){

                public boolean apply(Object input) {
                    return input instanceof InternalTenantContext;
                }
            }, null);
            CacheLoaderArgument cacheLoaderArgument = new CacheLoaderArgument(objectType, args, internalTenantContext, this.handle);
            return cache.get(cacheKey, cacheLoaderArgument);
        }
        return this.invokeRaw(method, args);
    }

    private ObjectType getObjectType() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int foundIndexForEntitySqlDao = -1;
        for (int i = 0; i < this.sqlDaoClass.getGenericInterfaces().length; ++i) {
            Type type = this.sqlDaoClass.getGenericInterfaces()[0];
            if (!(type instanceof ParameterizedType)) {
                return null;
            }
            if (!EntitySqlDao.class.getName().equals(((Class)((ParameterizedType)type).getRawType()).getName())) continue;
            foundIndexForEntitySqlDao = i;
            break;
        }
        if (foundIndexForEntitySqlDao >= 0) {
            Class<?> clz;
            Type[] types = ((ParameterizedType)this.sqlDaoClass.getGenericInterfaces()[foundIndexForEntitySqlDao]).getActualTypeArguments();
            int foundIndexForEntityModelDao = -1;
            block1: for (int i = 0; i < types.length; ++i) {
                Type[] genericInterfaces;
                clz = (Class<?>)types[i];
                for (Type genericInterface : genericInterfaces = clz.getGenericInterfaces()) {
                    if (!(genericInterface instanceof ParameterizedType) || !EntityModelDao.class.getName().equals(((Class)((ParameterizedType)genericInterface).getRawType()).getName())) continue;
                    foundIndexForEntityModelDao = i;
                    continue block1;
                }
            }
            if (foundIndexForEntityModelDao >= 0) {
                String modelClassName = ((Class)types[foundIndexForEntityModelDao]).getName();
                clz = Class.forName(modelClassName);
                EntityModelDao modelDao = (EntityModelDao)clz.newInstance();
                return modelDao.getTableName().getObjectType();
            }
        }
        return null;
    }

    private Object invokeWithAuditAndHistory(Audited auditedAnnotation, final Method method, final Object[] args) throws Throwable {
        InternalCallContext context = this.retrieveContextFromArguments(args);
        List<String> entityIds = this.retrieveEntityIdsFromArguments(method, args);
        ChangeType changeType = auditedAnnotation.value();
        HashMap deletedEntities = new HashMap();
        if (changeType == ChangeType.UPDATE || changeType == ChangeType.DELETE) {
            for (String entityId : entityIds) {
                deletedEntities.put(entityId, this.sqlDao.getById(entityId, (InternalTenantContext)context));
            }
        }
        Object obj = this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO_DETAILS, this.getProfilingId("raw", method), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

            public Object execute() throws Throwable {
                return method.invoke((Object)EntitySqlDaoWrapperInvocationHandler.this.sqlDao, args);
            }
        });
        EntityModelDao m = null;
        for (String entityId : entityIds) {
            m = this.updateHistoryAndAudit(entityId, (EntityModelDao)deletedEntities.get(entityId), changeType, context);
        }
        if (entityIds.size() == 1) {
            return m;
        }
        return obj;
    }

    private void populateCacheOnGetByIdInvocation(M model) {
        EntitySqlDaoWrapperInvocationHandler.populateCaches(this.cacheControllerDispatcher, model);
    }

    public static void populateCaches(CacheControllerDispatcher cacheControllerDispatcher, EntityModelDao model) {
        CacheController<String, Long> cacheRecordId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.RECORD_ID);
        cacheRecordId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getId().toString(), Cachable.CacheType.RECORD_ID, model.getTableName()), model.getRecordId());
        CacheController<String, UUID> cacheObjectId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.OBJECT_ID);
        cacheObjectId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getRecordId().toString(), Cachable.CacheType.OBJECT_ID, model.getTableName()), model.getId());
        if (model.getTenantRecordId() != null) {
            CacheController<String, Long> cacheTenantRecordId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_RECORD_ID);
            cacheTenantRecordId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getId().toString(), Cachable.CacheType.TENANT_RECORD_ID, model.getTableName()), model.getTenantRecordId());
        }
        if (model.getAccountRecordId() != null) {
            CacheController<String, Long> cacheAccountRecordId = cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_RECORD_ID);
            cacheAccountRecordId.putIfAbsent(EntitySqlDaoWrapperInvocationHandler.getKey(model.getId().toString(), Cachable.CacheType.ACCOUNT_RECORD_ID, model.getTableName()), model.getAccountRecordId());
        }
    }

    private static String getKey(String rawKey, Cachable.CacheType cacheType, TableName tableName) {
        return cacheType.isKeyPrefixedWithTableName() ? (Object)((Object)tableName) + "::" + rawKey : rawKey;
    }

    private M updateHistoryAndAudit(final String entityId, final @Nullable M deletedEntity, final ChangeType changeType, final InternalCallContext context) throws Throwable {
        Object reHydratedEntity = this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO_DETAILS, this.getProfilingId("history/audit", null), (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Object, Throwable>(){

            public M execute() throws Throwable {
                EntityModelDao reHydratedEntity = changeType == ChangeType.DELETE ? deletedEntity : (EntityModelDao)MoreObjects.firstNonNull(EntitySqlDaoWrapperInvocationHandler.this.sqlDao.getById(entityId, (InternalTenantContext)context), (Object)deletedEntity);
                Preconditions.checkNotNull((Object)reHydratedEntity, (Object)"reHydratedEntity cannot be null");
                Long entityRecordId = reHydratedEntity.getRecordId();
                TableName tableName = reHydratedEntity.getTableName();
                Long historyRecordId = tableName.getHistoryTableName() != null ? EntitySqlDaoWrapperInvocationHandler.this.insertHistory(entityRecordId, reHydratedEntity, changeType, context) : entityRecordId;
                EntitySqlDaoWrapperInvocationHandler.this.insertAudits(tableName, reHydratedEntity, entityRecordId, historyRecordId, changeType, context);
                return reHydratedEntity;
            }
        });
        return (M)((EntityModelDao)reHydratedEntity);
    }

    private List<String> retrieveEntityIdsFromArguments(Method method, Object[] args) {
        Annotation[][] parameterAnnotations = this.getAnnotations(method);
        int i = -1;
        for (Object arg : args) {
            ImmutableList.Builder<String> entityIds;
            ++i;
            if (arg instanceof Entity) {
                return ImmutableList.of((Object)((Entity)arg).getId().toString());
            }
            if (arg instanceof Iterable && (entityIds = this.extractEntityIdsFromBatchArgument((Iterable)arg)) != null) {
                return entityIds.build();
            }
            for (Annotation annotation : parameterAnnotations[i]) {
                if (arg instanceof String && Bind.class.equals(annotation.annotationType()) && "id".equals(((Bind)annotation).value())) {
                    return ImmutableList.of((Object)((String)arg));
                }
                if (!(arg instanceof Collection) || !BindIn.class.equals(annotation.annotationType()) || !"ids".equals(((BindIn)annotation).value())) continue;
                return ImmutableList.copyOf((Collection)((Collection)arg));
            }
        }
        return ImmutableList.of();
    }

    private Annotation[][] getAnnotations(Method method) {
        String methodString = method.toString();
        Annotation[][] parameterAnnotations = this.parameterAnnotationsByMethod.get(methodString);
        if (parameterAnnotations == null) {
            parameterAnnotations = method.getParameterAnnotations();
            this.parameterAnnotationsByMethod.put(methodString, parameterAnnotations);
        }
        return parameterAnnotations;
    }

    private ImmutableList.Builder<String> extractEntityIdsFromBatchArgument(Iterable arg) {
        Iterator iterator = arg.iterator();
        ImmutableList.Builder entityIds = new ImmutableList.Builder();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Entity)) {
                return null;
            }
            entityIds.add((Object)((Entity)object).getId().toString());
        }
        return entityIds;
    }

    private InternalCallContext retrieveContextFromArguments(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof InternalCallContext)) continue;
            return (InternalCallContext)arg;
        }
        return null;
    }

    private Long insertHistory(Long entityRecordId, M entityModelDao, ChangeType changeType, InternalCallContext context) {
        EntityHistoryModelDao history = new EntityHistoryModelDao(entityModelDao, entityRecordId, changeType, this.clock.getUTCNow());
        return this.sqlDao.addHistoryFromTransaction(history, context);
    }

    private void insertAudits(TableName tableName, M entityModelDao, Long entityRecordId, Long historyRecordId, ChangeType changeType, InternalCallContext contextMaybeWithoutAccountRecordId) {
        CacheController cacheController;
        InternalCallContext context;
        TableName destinationTableName = (TableName)((Object)MoreObjects.firstNonNull((Object)((Object)tableName.getHistoryTableName()), (Object)((Object)tableName)));
        EntityAudit audit = new EntityAudit(destinationTableName, historyRecordId, changeType, this.clock.getUTCNow());
        if (TableName.ACCOUNT.equals((Object)tableName) && ChangeType.INSERT.equals((Object)changeType)) {
            TimeZoneAwareEntity accountModelDao = (TimeZoneAwareEntity)entityModelDao;
            context = this.internalCallContextFactory.createInternalCallContext(accountModelDao, entityRecordId, contextMaybeWithoutAccountRecordId);
        } else {
            context = contextMaybeWithoutAccountRecordId;
        }
        this.sqlDao.insertAuditFromTransaction(audit, context);
        if (tableName.getHistoryTableName() != null) {
            cacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.AUDIT_LOG_VIA_HISTORY);
            if (cacheController != null) {
                String key = this.buildCacheKey((Map<Integer, Object>)ImmutableMap.of((Object)0, (Object)((Object)tableName.getHistoryTableName()), (Object)1, (Object)((Object)tableName.getHistoryTableName()), (Object)2, (Object)entityRecordId));
                cacheController.remove(key);
            }
        } else {
            cacheController = this.cacheControllerDispatcher.getCacheController(Cachable.CacheType.AUDIT_LOG);
            if (cacheController != null) {
                String key = this.buildCacheKey((Map<Integer, Object>)ImmutableMap.of((Object)0, (Object)((Object)tableName), (Object)1, (Object)entityRecordId));
                cacheController.remove(key);
            }
        }
    }

    private String buildCacheKey(Map<Integer, Object> keyPieces) {
        StringBuilder cacheKey = new StringBuilder();
        for (int i = 0; i < keyPieces.size(); ++i) {
            String str = String.valueOf(keyPieces.get(i)).toUpperCase();
            cacheKey.append(str);
            if (i >= keyPieces.size() - 1) continue;
            cacheKey.append("::");
        }
        return cacheKey.toString();
    }

    private String getProfilingId(@Nullable String prefix, @Nullable Method method) {
        StringBuilder stringBuilder = new StringBuilder().append(this.sqlDaoClass.getSimpleName());
        if (prefix != null) {
            stringBuilder.append(" (").append(prefix).append(")");
        }
        if (method != null) {
            stringBuilder.append(": ").append(method.getName());
        }
        return stringBuilder.toString();
    }
}

